# Generate AI Viral Videos with Seedance and Upload to TikTok, YouTube & Instagram
> **Category**: Social Media & Video
> **Views**: 214,907
> **Created**: 6/25/2025
## Description

Generate AI videos with Seedance & Blotato, upload to TikTok, YouTube & Instagram

Who is this for?

This template is ideal for creators, content marketers, social media managers, and AI enthusiasts who want to automate the production of short-form, visually captivating videos for platforms like TikTok, YouTube Shorts, and Instagram Reels — all without manual editing or publishing.

What problem is this workflow solving?

Creating engaging videos requires:
Generating creative ideas  
Writing detailed scene prompts  
Producing realistic video clips and sound effects  
Editing and stitching the final video  
Publishing across multiple platforms  

This workflow automates the entire process, saving hours of manual work and ensuring consistent, AI-driven content output ready for social distribution.

What this workflow does

This end-to-end AI video automation workflow:

Generates a creative idea using OpenAI and LangChain  
Creates detailed video prompts with Seedance AI  
Generates video clips via Wavespeed AI  
Generates sound effects with Fal AI  
Stitches the final video using Fal AI’s ffmpeg API  
Logs metadata and video links to Google Sheets  
Uploads the video to Blotato  
Auto-publishes to TikTok, YouTube, Instagram, and other platforms

Setup

Add your OpenAI API key in the LLM nodes  
Set up Seedance and Wavespeed AI credentials for video prompt and clip generation  
Add your Fal AI API key for sound and stitching steps  
Connect your Google Sheets account for tracking ideas and outputs  
Set your Blotato API key and fill in the platform account IDs in the Assign Social Media IDs node  
Adjust the Schedule Trigger to control when the automation runs  

How to customize this workflow to your needs

Change the AI prompts** to target your niche (e.g., ASMR, product videos, humor)  
Add a Telegram or Slack step** for video preview before publishing  
Tweak scene structure** or video duration to match your style  
Disable platforms** you don’t want by turning off specific HTTP Request nodes  
Edit the sound generation prompts** for different moods or effects  

📄 Documentation: Notion Guide

Need help customizing?
Contact me for consulting and support : Linkedin / Youtube
## Workflow Structure
# Generate AI Viral Videos with Seedance and Upload to TikTok, YouTube & Instagram

## Basic Information

- Node count: 34
- Connection count: 41

## Key Nodes

### Triggers
- Trigger: Start Daily Content Generation (`n8n-nodes-base.scheduleTrigger`)

### AI Nodes
- Tool: Inject Creative Perspective (Idea) (`@n8n/n8n-nodes-langchain.toolThink`)
- Parse AI Output (Idea, Environment, Sound) (`@n8n/n8n-nodes-langchain.outputParserStructured`)
- LLM: Draft Video Prompt Details (GPT-4.1) (`@n8n/n8n-nodes-langchain.lmChatOpenAi`)
- Tool: Refine and Validate Prompts1 (`@n8n/n8n-nodes-langchain.toolThink`)
- Parse Structured Video Prompt Output (`@n8n/n8n-nodes-langchain.outputParserStructured`)
- Generate Creative Video Idea (`@n8n/n8n-nodes-langchain.agent`)
- Generate Detailed Video Prompts (`@n8n/n8n-nodes-langchain.agent`)
- LLM: Generate Raw Idea (GPT-5) (`@n8n/n8n-nodes-langchain.lmChatOpenAi`)

## All Nodes

| Node Name | Type | Category |
|-----------|------|----------|
| Trigger: Start Daily Content Generation | `n8n-nodes-base.scheduleTrigger` | Trigger |
| Tool: Inject Creative Perspective (Idea) | `@n8n/n8n-nodes-langchain.toolThink` | AI |
| Parse AI Output (Idea, Environment, Sound) | `@n8n/n8n-nodes-langchain.outputParserStructured` | AI |
| Save Idea & Metadata to Google Sheets | `n8n-nodes-base.googleSheets` | Input |
| LLM: Draft Video Prompt Details (GPT-4.1) | `@n8n/n8n-nodes-langchain.lmChatOpenAi` | AI |
| Tool: Refine and Validate Prompts1 | `@n8n/n8n-nodes-langchain.toolThink` | AI |
| Parse Structured Video Prompt Output | `@n8n/n8n-nodes-langchain.outputParserStructured` | AI |
| Extract Individual Scene Descriptions | `n8n-nodes-base.code` | Transform |
| Wait for Clip Generation (Wavespeed AI) | `n8n-nodes-base.wait` | Other |
| Retrieve Video Clips | `n8n-nodes-base.httpRequest` | Output |
| Generate ASMR Sound (Fal AI) | `n8n-nodes-base.httpRequest` | Output |
| Wait for Sound Generation (Fal AI) | `n8n-nodes-base.wait` | Other |
| Retrieve Final Sound Output | `n8n-nodes-base.httpRequest` | Output |
| List Clip URLs for Stitching | `n8n-nodes-base.code` | Transform |
| Merge Clips into Final Video (Fal AI) | `n8n-nodes-base.httpRequest` | Output |
| Wait for Video Rendering (Fal AI) | `n8n-nodes-base.wait` | Other |
| Retrieve Final Merged Video | `n8n-nodes-base.httpRequest` | Output |
| URL Final Video | `n8n-nodes-base.googleSheets` | Input |
| Generate Creative Video Idea | `@n8n/n8n-nodes-langchain.agent` | AI |
| Generate Detailed Video Prompts | `@n8n/n8n-nodes-langchain.agent` | AI |
| Generate Video Clips (seedance) | `n8n-nodes-base.httpRequest` | Output |
| Upload Video to BLOTATO | `@blotato/n8n-nodes-blotato.blotato` | Other |
| Youtube | `@blotato/n8n-nodes-blotato.blotato` | Other |
| Tiktok | `@blotato/n8n-nodes-blotato.blotato` | Other |
| Merge | `n8n-nodes-base.merge` | Transform |
| Update Status to "DONE" | `n8n-nodes-base.googleSheets` | Input |
| Linkedin | `@blotato/n8n-nodes-blotato.blotato` | Other |
| Facebook | `@blotato/n8n-nodes-blotato.blotato` | Other |
| Instagram | `@blotato/n8n-nodes-blotato.blotato` | Other |
| Threads | `@blotato/n8n-nodes-blotato.blotato` | Other |
| Bluesky | `@blotato/n8n-nodes-blotato.blotato` | Other |
| Pinterest | `@blotato/n8n-nodes-blotato.blotato` | Other |
| Twitter (X) | `@blotato/n8n-nodes-blotato.blotato` | Other |
| LLM: Generate Raw Idea (GPT-5) | `@n8n/n8n-nodes-langchain.lmChatOpenAi` | AI |

## Connections

```
Merge --[main]--> Update Status to "DONE"
Tiktok --[main]--> Merge
Bluesky --[main]--> Merge
Threads --[main]--> Merge
Youtube --[main]--> Merge
Facebook --[main]--> Merge
Linkedin --[main]--> Merge
Instagram --[main]--> Merge
Pinterest --[main]--> Merge
Twitter (X) --[main]--> Merge
URL Final Video --[main]--> Upload Video to BLOTATO
Retrieve Video Clips --[main]--> Generate ASMR Sound (Fal AI)
Upload Video to BLOTATO --[main]--> Tiktok
Upload Video to BLOTATO --[main]--> Linkedin
Upload Video to BLOTATO --[main]--> Facebook
Upload Video to BLOTATO --[main]--> Instagram
Upload Video to BLOTATO --[main]--> Twitter (X)
Upload Video to BLOTATO --[main]--> Youtube
Upload Video to BLOTATO --[main]--> Threads
Upload Video to BLOTATO --[main]--> Bluesky
Upload Video to BLOTATO --[main]--> Pinterest
Retrieve Final Merged Video --[main]--> URL Final Video
Retrieve Final Sound Output --[main]--> List Clip URLs for Stitching
Generate ASMR Sound (Fal AI) --[main]--> Wait for Sound Generation (Fal AI)
Generate Creative Video Idea --[main]--> Save Idea & Metadata to Google Sheets
List Clip URLs for Stitching --[main]--> Merge Clips into Final Video (Fal AI)
LLM: Generate Raw Idea (GPT-5) --[ai_languageModel]--> Generate Creative Video Idea
Generate Detailed Video Prompts --[main]--> Extract Individual Scene Descriptions
Generate Video Clips (seedance) --[main]--> Wait for Clip Generation (Wavespeed AI)
Wait for Video Rendering (Fal AI) --[main]--> Retrieve Final Merged Video
Tool: Refine and Validate Prompts1 --[ai_tool]--> Generate Detailed Video Prompts
Wait for Sound Generation (Fal AI) --[main]--> Retrieve Final Sound Output
Parse Structured Video Prompt Output --[ai_outputParser]--> Generate Detailed Video Prompts
Extract Individual Scene Descriptions --[main]--> Generate Video Clips (seedance)
Merge Clips into Final Video (Fal AI) --[main]--> Wait for Video Rendering (Fal AI)
Save Idea & Metadata to Google Sheets --[main]--> Generate Detailed Video Prompts
Trigger: Start Daily Content Generation --[main]--> Generate Creative Video Idea
Wait for Clip Generation (Wavespeed AI) --[main]--> Retrieve Video Clips
Tool: Inject Creative Perspective (Idea) --[ai_tool]--> Generate Creative Video Idea
LLM: Draft Video Prompt Details (GPT-4.1) --[ai_languageModel]--> Generate Detailed Video Prompts
Parse AI Output (Idea, Environment, Sound) --[ai_outputParser]--> Generate Creative Video Idea
```

## Workflow Summary

This workflow is triggered by Trigger: Start Daily Content Generation, uses Tool: Inject Creative Perspective (Idea), Parse AI Output (Idea, Environment, Sound), LLM: Draft Video Prompt Details (GPT-4.1), Tool: Refine and Validate Prompts1, Parse Structured Video Prompt Output, Generate Creative Video Idea, Generate Detailed Video Prompts, LLM: Generate Raw Idea (GPT-5) for AI processing, goes through 3 transformation step(s), finally outputs to Retrieve Video Clips, Generate ASMR Sound (Fal AI), Retrieve Final Sound Output, Merge Clips into Final Video (Fal AI), Retrieve Final Merged Video, Generate Video Clips (seedance).
## Author Information
- **Name**: Dr. Firas
- **Username**: @drfiras
- Verified user
## Related Links
- [View this template on n8n.io](https://n8n.io/workflows/5338)
## Complete Workflow JSON
<details>
<summary>Click to expand Workflow JSON</summary>
```json
{
  "id": 5338,
  "meta": {
    "instanceId": "a2b23892dd6989fda7c1209b381f5850373a7d2b85609624d7c2b7a092671d44",
    "templateCredsSetupCompleted": true
  },
  "name": "Generate AI Viral Videos with Seedance and Upload to TikTok, YouTube & Instagram",
  "tags": [],
  "nodes": [
    {
      "id": "b0bfcf76-242e-46b9-b70d-9d569d20136b",
      "name": "Sticky Note10",
      "type": "n8n-nodes-base.stickyNote",
      "position": [
        592,
        464
      ],
      "parameters": {
        "color": 2,
        "width": 880,
        "height": 256,
        "content": "## | Step 1: Generate Clips (Seedance)\n"
      },
      "typeVersion": 1
    },
    {
      "id": "194bda13-961d-4209-91f9-b5bcc8969d39",
      "name": "Sticky Note13",
      "type": "n8n-nodes-base.stickyNote",
      "position": [
        1504,
        464
      ],
      "parameters": {
        "color": 2,
        "width": 640,
        "height": 256,
        "content": "## | Step 2: Generate Sounds (Fal AI)\n"
      },
      "typeVersion": 1
    },
    {
      "id": "7c81a4b7-672f-4df4-9452-a205385028d7",
      "name": "Sticky Note14",
      "type": "n8n-nodes-base.stickyNote",
      "position": [
        592,
        -96
      ],
      "parameters": {
        "color": 7,
        "width": 1560,
        "height": 540,
        "content": "## | INPUT: Starting Idea Section"
      },
      "typeVersion": 1
    },
    {
      "id": "bc65e9e0-1265-4013-9d6c-7a0a535d3996",
      "name": "Sticky Note",
      "type": "n8n-nodes-base.stickyNote",
      "position": [
        592,
        752
      ],
      "parameters": {
        "color": 3,
        "width": 1560,
        "height": 260,
        "content": "## | Step 3: Stitch Video (Fal AI)"
      },
      "typeVersion": 1
    },
    {
      "id": "7325db24-3e91-422c-805f-4b20c9173231",
      "name": "Sticky Note2",
      "type": "n8n-nodes-base.stickyNote",
      "disabled": true,
      "position": [
        592,
        1040
      ],
      "parameters": {
        "color": 4,
        "width": 1560,
        "height": 760,
        "content": "## | Step 4 — Publish Video to Social Media\n"
      },
      "typeVersion": 1
    },
    {
      "id": "a9ec7bac-5dcb-452c-b326-5caf7ba239ef",
      "name": "Trigger: Start Daily Content Generation",
      "type": "n8n-nodes-base.scheduleTrigger",
      "position": [
        640,
        0
      ],
      "parameters": {
        "rule": {
          "interval": [
            {}
          ]
        }
      },
      "typeVersion": 1.2
    },
    {
      "id": "ff405b6a-9d01-4a5b-8b96-322cdac61d55",
      "name": "Tool: Inject Creative Perspective (Idea)",
      "type": "@n8n/n8n-nodes-langchain.toolThink",
      "position": [
        1088,
        288
      ],
      "parameters": {},
      "typeVersion": 1
    },
    {
      "id": "58e66ae7-debf-45c2-aa99-8b507b5d56cb",
      "name": "Parse AI Output (Idea, Environment, Sound)",
      "type": "@n8n/n8n-nodes-langchain.outputParserStructured",
      "position": [
        1248,
        288
      ],
      "parameters": {
        "jsonSchemaExample": "[\n  {\n    \"Caption\": \"Diver Removes Nets Off Whale 🐋 #whalerescue #marinelife #oceanrescue #seahelpers #love #nature #instagood #explore #viral #savenature #oceanguardians #cleanoceans\",\n    \"Idea\": \"Diver carefully cuts tangled net from distressed whale in open sea\",\n    \"Environment\": \"Open ocean, sunlight beams through water, diver and whale, cinematic realism\",\n    \"Sound\": \"Primary sound description under 15 words\",\n    \"Status\": \"for production\"\n  }\n]\n"
      },
      "typeVersion": 1.2
    },
    {
      "id": "ad438d7b-b0f5-4801-87df-e313bfb9c83f",
      "name": "Save Idea & Metadata to Google Sheets",
      "type": "n8n-nodes-base.googleSheets",
      "position": [
        1424,
        0
      ],
      "parameters": {
        "columns": {
          "value": {
            "id": "==ROW()-1",
            "idea": "={{ $json.output[0].Idea }}",
            "caption": "={{ $json.output[0].Caption }}",
            "production": "={{ $json.output[0].Status }}",
            "sound_prompt": "={{ $json.output[0].Sound }}",
            "environment_prompt": "={{ $json.output[0].Environment }}"
          },
          "schema": [
            {
              "id": "id",
              "type": "string",
              "display": true,
              "removed": false,
              "required": false,
              "displayName": "id",
              "defaultMatch": true,
              "canBeUsedToMatch": true
            },
            {
              "id": "idea",
              "type": "string",
              "display": true,
              "required": false,
              "displayName": "idea",
              "defaultMatch": false,
              "canBeUsedToMatch": true
            },
            {
              "id": "caption",
              "type": "string",
              "display": true,
              "required": false,
              "displayName": "caption",
              "defaultMatch": false,
              "canBeUsedToMatch": true
            },
            {
              "id": "production",
              "type": "string",
              "display": true,
              "required": false,
              "displayName": "production",
              "defaultMatch": false,
              "canBeUsedToMatch": true
            },
            {
              "id": "environment_prompt",
              "type": "string",
              "display": true,
              "required": false,
              "displayName": "environment_prompt",
              "defaultMatch": false,
              "canBeUsedToMatch": true
            },
            {
              "id": "sound_prompt",
              "type": "string",
              "display": true,
              "required": false,
              "displayName": "sound_prompt",
              "defaultMatch": false,
              "canBeUsedToMatch": true
            },
            {
              "id": "final_output",
              "type": "string",
              "display": true,
              "removed": true,
              "required": false,
              "displayName": "final_output",
              "defaultMatch": false,
              "canBeUsedToMatch": true
            }
          ],
          "mappingMode": "defineBelow",
          "matchingColumns": [
            "id"
          ],
          "attemptToConvertTypes": false,
          "convertFieldsToString": false
        },
        "options": {},
        "operation": "append",
        "sheetName": {
          "__rl": true,
          "mode": "id",
          "value": "="
        },
        "documentId": {
          "__rl": true,
          "mode": "id",
          "value": "="
        }
      },
      "credentials": {
        "googleSheetsOAuth2Api": {
          "id": "51us92xkOlrvArhV",
          "name": "Google Sheets account"
        }
      },
      "typeVersion": 4.5
    },
    {
      "id": "1d465451-7574-446b-b69f-94b5acc68e93",
      "name": "LLM: Draft Video Prompt Details (GPT-4.1)",
      "type": "@n8n/n8n-nodes-langchain.lmChatOpenAi",
      "position": [
        1664,
        288
      ],
      "parameters": {
        "model": {
          "__rl": true,
          "mode": "list",
          "value": "gpt-4.1",
          "cachedResultName": "gpt-4.1"
        },
        "options": {}
      },
      "credentials": {
        "openAiApi": {
          "id": "6h3DfVhNPw9I25nO",
          "name": "OpenAi account"
        }
      },
      "typeVersion": 1.2
    },
    {
      "id": "7de105c4-c5d4-4b53-8453-2a396b172027",
      "name": "Tool: Refine and Validate Prompts1",
      "type": "@n8n/n8n-nodes-langchain.toolThink",
      "position": [
        1840,
        288
      ],
      "parameters": {},
      "typeVersion": 1
    },
    {
      "id": "0f0c5fbd-5051-4e11-a9a1-5f4fca652084",
      "name": "Parse Structured Video Prompt Output",
      "type": "@n8n/n8n-nodes-langchain.outputParserStructured",
      "position": [
        2000,
        288
      ],
      "parameters": {
        "jsonSchemaExample": "{\n  \"Idea\": \"An obsidian rock being sliced with a shimmering knife\",\n  \"Environment\": \"Clean studio table, subtle light reflections\",\n  \"Sound\": \"Crisp slicing, deep grinding, and delicate crumbling\",\n  \"Scene 1\": \"Extreme macro shot: a razor-sharp, polished knife blade presses into the dark, granular surface of an obsidian rock, just beginning to indent.\",\n  \"Scene 2\": \"Close-up: fine, iridescent dust particles erupt from the point of contact as the blade cuts deeper into the obsidian, catching the studio light.\",\n  \"Scene 3\": \"Mid-shot: the knife, held perfectly steady, has formed a shallow, clean groove across the obsidian's shimmering surface, revealing a new, smooth texture.\"\n}"
      },
      "typeVersion": 1.2
    },
    {
      "id": "a5b35e3b-6dfe-4148-afd7-6eaf25a76658",
      "name": "Extract Individual Scene Descriptions",
      "type": "n8n-nodes-base.code",
      "position": [
        688,
        544
      ],
      "parameters": {
        "jsCode": "function findSceneEntries(obj) {\n  const scenes = [];\n\n  for (const [key, value] of Object.entries(obj)) {\n    if (key.toLowerCase().startsWith(\"scene\") && typeof value === \"string\") {\n      scenes.push(value);\n    } else if (typeof value === \"object\" && value !== null) {\n      scenes.push(...findSceneEntries(value));\n    }\n  }\n\n  return scenes;\n}\n\nlet output = [];\n\ntry {\n  const inputData = items[0].json;\n  const scenes = findSceneEntries(inputData);\n\n  if (scenes.length === 0) {\n    throw new Error(\"No scene keys found at any level.\");\n  }\n\n  output = scenes.map(scene => ({ description: scene }));\n} catch (e) {\n  throw new Error(\"Could not extract scenes properly. Details: \" + e.message);\n}\n\nreturn output;\n"
      },
      "typeVersion": 2
    },
    {
      "id": "08abfd2d-8b1f-43d2-8cec-e65755184060",
      "name": "Wait for Clip Generation (Wavespeed AI)",
      "type": "n8n-nodes-base.wait",
      "position": [
        1088,
        544
      ],
      "webhookId": "e455bc41-86f8-4cff-bf9b-e07013f1b84b",
      "parameters": {
        "unit": "minutes",
        "amount": 4
      },
      "typeVersion": 1.1
    },
    {
      "id": "1a9bc668-9f94-46d5-b615-8d2fc0f189aa",
      "name": "Retrieve Video Clips",
      "type": "n8n-nodes-base.httpRequest",
      "position": [
        1280,
        544
      ],
      "parameters": {
        "url": "=https://api.wavespeed.ai/api/v3/predictions/{{ $json.data.id }}/result",
        "options": {},
        "authentication": "genericCredentialType",
        "genericAuthType": "httpHeaderAuth"
      },
      "credentials": {
        "httpHeaderAuth": {
          "id": "QhpKhFJMiQAReugp",
          "name": "Header Auth account 4"
        }
      },
      "typeVersion": 4.2
    },
    {
      "id": "97119070-cee3-44e3-aea7-b3c74dbc63d9",
      "name": "Generate ASMR Sound (Fal AI)",
      "type": "n8n-nodes-base.httpRequest",
      "position": [
        1568,
        544
      ],
      "parameters": {
        "url": "https://queue.fal.run/fal-ai/mmaudio-v2 ",
        "method": "POST",
        "options": {
          "batching": {
            "batch": {
              "batchSize": 1,
              "batchInterval": 2000
            }
          }
        },
        "jsonBody": "={\n  \"prompt\": \"ASMR Soothing sound effects. {{$('Generate Detailed Video Prompts').item.json.output.Sound}}\",\n  \"duration\": 10,\n  \"video_url\": \"{{$json.data.outputs[0]}}\"\n}\n",
        "sendBody": true,
        "specifyBody": "json",
        "authentication": "genericCredentialType",
        "genericAuthType": "httpHeaderAuth"
      },
      "credentials": {
        "httpHeaderAuth": {
          "id": "kNULkYDcOZG3X0be",
          "name": "Fal.ai"
        }
      },
      "typeVersion": 4.2
    },
    {
      "id": "a7c6bedd-d091-464d-ba9c-63fa5fcaad0e",
      "name": "Wait for Sound Generation (Fal AI)",
      "type": "n8n-nodes-base.wait",
      "position": [
        1760,
        544
      ],
      "webhookId": "e8e18e73-aa86-4e39-9bf3-3796a4bd7efc",
      "parameters": {
        "unit": "minutes",
        "amount": 4
      },
      "typeVersion": 1.1
    },
    {
      "id": "98b705bc-7209-4f63-ac20-29e32fa8745d",
      "name": "Retrieve Final Sound Output",
      "type": "n8n-nodes-base.httpRequest",
      "position": [
        1968,
        544
      ],
      "parameters": {
        "url": "=https://queue.fal.run/fal-ai/mmaudio-v2/requests/{{ $json.request_id }}",
        "options": {},
        "authentication": "genericCredentialType",
        "genericAuthType": "httpHeaderAuth"
      },
      "credentials": {
        "httpHeaderAuth": {
          "id": "kNULkYDcOZG3X0be",
          "name": "Fal.ai"
        }
      },
      "typeVersion": 4.2
    },
    {
      "id": "d5d687e8-2043-4c0a-83fa-216e02810f68",
      "name": "List Clip URLs for Stitching",
      "type": "n8n-nodes-base.code",
      "position": [
        688,
        800
      ],
      "parameters": {
        "jsCode": "return [\n  {\n    video_urls: items.map(item => item.json.video.url)\n  }\n];"
      },
      "typeVersion": 2
    },
    {
      "id": "bd5d153b-9636-4939-b13a-6f9119ff7f91",
      "name": "Merge Clips into Final Video (Fal AI)",
      "type": "n8n-nodes-base.httpRequest",
      "position": [
        880,
        800
      ],
      "parameters": {
        "url": "https://queue.fal.run/fal-ai/ffmpeg-api/compose",
        "body": "={\n  \"tracks\": [\n    {\n      \"id\": \"1\",\n      \"type\": \"video\",\n      \"keyframes\": [\n        { \"url\": \"{{ $json.video_urls[0] }}\", \"timestamp\": 0, \"duration\": 10 },\n        { \"url\": \"{{ $json.video_urls[1] }}\", \"timestamp\": 10, \"duration\": 10 },\n        { \"url\": \"{{ $json.video_urls[2] }}\", \"timestamp\": 20, \"duration\": 10 }\n      ]\n    }\n  ]\n}",
        "method": "POST",
        "options": {
          "batching": {
            "batch": {
              "batchSize": 1,
              "batchInterval": 2000
            }
          }
        },
        "sendBody": true,
        "contentType": "raw",
        "authentication": "genericCredentialType",
        "rawContentType": "application/json",
        "genericAuthType": "httpHeaderAuth"
      },
      "credentials": {
        "httpHeaderAuth": {
          "id": "kNULkYDcOZG3X0be",
          "name": "Fal.ai"
        }
      },
      "typeVersion": 4.2
    },
    {
      "id": "5d63981d-857a-4912-bab2-8c5023e4b6f7",
      "name": "Wait for Video Rendering (Fal AI)",
      "type": "n8n-nodes-base.wait",
      "position": [
        1088,
        800
      ],
      "webhookId": "07938be9-7910-4908-b554-64f43be9e763",
      "parameters": {
        "unit": "minutes",
        "amount": 4
      },
      "typeVersion": 1.1
    },
    {
      "id": "a2325f16-6c9a-4e31-aacc-fec98bdf30ac",
      "name": "Retrieve Final Merged Video",
      "type": "n8n-nodes-base.httpRequest",
      "position": [
        1280,
        800
      ],
      "parameters": {
        "url": "=https://queue.fal.run/fal-ai/ffmpeg-api/requests/{{ $json.request_id }}",
        "options": {},
        "authentication": "genericCredentialType",
        "genericAuthType": "httpHeaderAuth"
      },
      "credentials": {
        "httpHeaderAuth": {
          "id": "kNULkYDcOZG3X0be",
          "name": "Fal.ai"
        }
      },
      "typeVersion": 4.2
    },
    {
      "id": "cc0c7ce6-f77e-4a72-b317-e2196e4894c5",
      "name": "URL Final Video",
      "type": "n8n-nodes-base.googleSheets",
      "position": [
        1968,
        800
      ],
      "parameters": {
        "columns": {
          "value": {
            "idea": "={{ $('Save Idea & Metadata to Google Sheets').first().json.idea }}",
            "production": "done",
            "final_output": "={{ $json.video_url }}"
          },
          "schema": [
            {
              "id": "id",
              "type": "string",
              "display": true,
              "removed": true,
              "required": false,
              "displayName": "id",
              "defaultMatch": true,
              "canBeUsedToMatch": true
            },
            {
              "id": "idea",
              "type": "string",
              "display": true,
              "removed": false,
              "required": false,
              "displayName": "idea",
              "defaultMatch": false,
              "canBeUsedToMatch": true
            },
            {
              "id": "caption",
              "type": "string",
              "display": true,
              "removed": true,
              "required": false,
              "displayName": "caption",
              "defaultMatch": false,
              "canBeUsedToMatch": true
            },
            {
              "id": "production",
              "type": "string",
              "display": true,
              "required": false,
              "displayName": "production",
              "defaultMatch": false,
              "canBeUsedToMatch": true
            },
            {
              "id": "environment_prompt",
              "type": "string",
              "display": true,
              "removed": true,
              "required": false,
              "displayName": "environment_prompt",
              "defaultMatch": false,
              "canBeUsedToMatch": true
            },
            {
              "id": "sound_prompt",
              "type": "string",
              "display": true,
              "removed": true,
              "required": false,
              "displayName": "sound_prompt",
              "defaultMatch": false,
              "canBeUsedToMatch": true
            },
            {
              "id": "final_output",
              "type": "string",
              "display": true,
              "required": false,
              "displayName": "final_output",
              "defaultMatch": false,
              "canBeUsedToMatch": true
            },
            {
              "id": "row_number",
              "type": "number",
              "display": true,
              "removed": true,
              "readOnly": true,
              "required": false,
              "displayName": "row_number",
              "defaultMatch": false,
              "canBeUsedToMatch": true
            }
          ],
          "mappingMode": "defineBelow",
          "matchingColumns": [
            "idea"
          ],
          "attemptToConvertTypes": false,
          "convertFieldsToString": false
        },
        "options": {},
        "operation": "update",
        "sheetName": {
          "__rl": true,
          "mode": "id",
          "value": "="
        },
        "documentId": {
          "__rl": true,
          "mode": "id",
          "value": "="
        }
      },
      "credentials": {
        "googleSheetsOAuth2Api": {
          "id": "51us92xkOlrvArhV",
          "name": "Google Sheets account"
        }
      },
      "typeVersion": 4.5
    },
    {
      "id": "25073052-c9f9-49a2-89c9-3fda74f9cef8",
      "name": "Sticky Note11",
      "type": "n8n-nodes-base.stickyNote",
      "position": [
        -128,
        -96
      ],
      "parameters": {
        "color": 6,
        "width": 700,
        "height": 1892,
        "content": "# 🎬 Generate AI Videos with Seedance & Blotato, Upload to TikTok, YouTube & Instagram  \n\n---\n\n## 🎥 Full Tutorial  \n\n## [Video Tutorial](https://youtu.be/AzOgpdn8ngY)  \n@[youtube](AzOgpdn8ngY)\n\n---\n\n## 📘 Documentation  \nAccess detailed instructions, API guides, platform connections, and workflow customization:  \n\n📎 [Open full documentation on Notion](https://automatisation.notion.site/Generate-AI-Videos-with-Seedance-Blotato-and-Upload-to-TikTok-YouTube-Instagram-version-II-21d3d6550fd980218096d84f31bfae2d?source=copy_link)\n\n---\n\n## ⚙️ Requirements\n\n1. ✅ **OpenAI API Key** (added in LLM nodes)  \n2. 🎨 **Seedance AI & Wavespeed AI credentials** (for prompt and video clip generation)  \n3. 🔊 **Fal AI API Key** (for sound effects + stitching via ffmpeg API)  \n4. 📦 **n8n installed** (latest version recommended)  \n5. 📝 **Google Sheets connected** (used to log ideas and outputs)  \n   👉 [Google Sheet to copy](https://docs.google.com/spreadsheets/d/1Vd4XjcKZR_8cJ-2uqhOMZGc6GOULuHh_K3iDPvovw9E/copy)  \n6. ☁️ **Blotato API Key + configured social accounts** (TikTok, YouTube, Instagram, etc.)  \n7. ⏰ **Schedule Trigger setup** to define generation/publishing frequency  \n\n---\n\n## 📝 Workflow Steps in n8n\n\n1. **Trigger / Start Node**  \n   Example: scheduled trigger or manual execution.  \n\n2. **Content Creation**  \n   - OpenAI + LangChain generate creative ideas.  \n   - Seedance produces detailed video prompts.  \n   - Wavespeed AI generates video clips.  \n   - Fal AI adds sound + final editing (ffmpeg API).  \n\n3. **Logging & Upload**  \n   - Metadata + links saved in Google Sheets.  \n   - Automatic upload via **Blotato**.  \n   - Publish to TikTok, YouTube, Instagram, etc.  \n\n---\n\n## 🎛 Need help customizing?\n\n**Contact me for consulting and support:** [LinkedIn](https://www.linkedin.com/in/dr-firas/) / [YouTube](https://www.youtube.com/@DRFIRASS)  \n"
      },
      "typeVersion": 1
    },
    {
      "id": "95548f68-3784-4cfa-8f26-88672710982a",
      "name": "Generate Creative Video Idea",
      "type": "@n8n/n8n-nodes-langchain.agent",
      "position": [
        960,
        0
      ],
      "parameters": {
        "text": "Generate a creative concept involving:\n\n[[\nA solid, hard material or element being sliced cleanly with a sharp blade. Your response must follow this structure:\n\n\"(Color) (Material) shaped like a (random everyday object)\"\n\nFor inspiration, imagine examples like: obsidian shaped like a chess piece, quartz shaped like a coffee mug, sapphire shaped like a seashell, or titanium shaped like a leaf.\n\n]]\n\nReflect carefully before answering to ensure originality and visual appeal.\n\nUse the Think tool to review your output",
        "options": {
          "systemMessage": "=**Role:**  \nYou are an AI designed to generate **one immersive, realistic idea** based on a user-provided topic. Your output must be formatted as a **single-line JSON array** and follow the rules below exactly.\n\n---\n\n### RULES\n\n1. **Number of ideas**  \n   - Return **only one idea**.\n\n2. **Topic**  \n   - The user will provide a keyword (e.g., “glass cutting ASMR,” “wood carving sounds,” “satisfying rock splits”).\n\n3. **Idea**  \n   - Maximum 13 words.  \n   - Describe a viral-worthy, original, or surreal moment related to the topic.\n\n4. **Caption**  \n   - Short, punchy, viral-friendly.  \n   - Include **one emoji**.  \n   - Exactly **12 hashtags** in this order:  \n     1. 4 topic-relevant hashtags  \n     2. 4 all-time most popular hashtags  \n     3. 4 currently trending hashtags (based on live research)  \n   - All in lowercase.\n\n5. **Environment**  \n   - Maximum 20 words.  \n   - Must match the action in the Idea exactly.  \n   - Specify location (studio table, natural terrain, lab bench…), visual details (dust particles, polished surface, subtle reflections…), and style (macro close-up, cinematic slow-motion, minimalist…).\n\n6. **Sound**  \n   - Maximum 15 words.  \n   - Describe the primary sound for the scene (to feed into an audio model).\n\n7. **Status**  \n   - Always set to `\"for production\"`.\n\n---\n\n### OUTPUT FORMAT (single-line JSON array)\n\n```json\n[\n  {\n    \"Caption\": \"Your short viral title with emoji #4_topic_hashtags #4_all_time_popular_hashtags #4_trending_hashtags\",\n    \"Idea\": \"Your idea under 13 words\",\n    \"Environment\": \"Your vivid setting under 20 words matching the action\",\n    \"Sound\": \"Your primary sound description under 15 words\",\n    \"Status\": \"for production\"\n  }\n]\n"
        },
        "promptType": "define",
        "hasOutputParser": true
      },
      "typeVersion": 1.9
    },
    {
      "id": "3d72df45-beca-4a5b-b0dd-1a8ed583d952",
      "name": "Generate Detailed Video Prompts",
      "type": "@n8n/n8n-nodes-langchain.agent",
      "position": [
        1760,
        0
      ],
      "parameters": {
        "text": "=Give me 3 video prompts based on the previous idea\n\nUse the Think tool to review your output",
        "options": {
          "systemMessage": "=Role: You are a prompt-generation AI specializing in cinematic, ASMR-style video prompts. Your task is to generate a multi-scene video sequence that vividly shows a sharp knife actively cutting through a specific object in a clean, high-detail setting.\n\nYour writing must follow this style:\n\nSharp, precise cinematic realism.\n\nMacro-level detail with tight focus on the blade interacting with the object.\n\nThe knife must always be in motion — slicing, splitting, or gliding through the material. Never idle or static.\n\nCamera terms are allowed (e.g. macro view, tight angle, over-the-blade shot).\n\nEach scene must contain all of the following, expressed through detailed visual language:\n\n✅ The main object or subject (from the Idea)\n\n✅ The cutting environment or surface (from the Environment)\n\n✅ The texture, structure, and behavior of the material as it’s being cut\n\n✅ A visible, sharp blade actively cutting\n\nDescriptions should show:\n\nThe physical makeup of the material — is it translucent, brittle, dense, reflective, granular, fibrous, layered, or fluid-filled?\n\nHow the material responds to the blade — resistance, cracking, tearing, smooth separation, tension, vibration.\n\nThe interaction between the blade and the surface — light reflection, buildup of particles, contact points, residue or dust.\n\nAny ASMR-relevant sensory cues like particle release, shimmer, or subtle movement, but always shown visually — not narrated.\n\nTone:\n\nClean, clinical, visual.\n\nNo poetic metaphors, emotion, or storytelling.\n\nAvoid fantasy or surreal imagery.\n\nAll description must feel physically grounded and logically accurate.\n\nLength:\n\nEach scene must be between 1,000 and 2,000 characters.\n\nNo shallow or repetitive scenes — each must be immersive, descriptive, and specific.\n\nEach scene should explore a distinct phase of the cutting process, a different camera perspective, or a new behavior of the material under the blade.\n\nInputs:\n\nIdea: \"{{ $json.idea }}\"\nEnvironment: \"{{ $json.environment_prompt }}\"\nSound: \"{{ $json.sound_prompt }}\"\n\nFormat:\n\nIdea: \"...\"\nEnvironment: \"...\"\nSound: \"...\"\n\nScene 1: \"...\"\nScene 2: \"...\"\nScene 3: \"...\"\nScene 4: \"...\"\nScene 5: \"...\"\nScene 6: \"...\"\nScene 7: \"...\"\nScene 8: \"...\"\nScene 9: \"...\"\nScene 10: \"...\"\nScene 11: \"...\"\nScene 12: \"...\"\nScene 13: \"...\"\n\n"
        },
        "promptType": "define",
        "hasOutputParser": true
      },
      "typeVersion": 1.9
    },
    {
      "id": "d31597c6-f9e3-48d6-8a61-9a4424ef7021",
      "name": "Generate Video Clips (seedance)",
      "type": "n8n-nodes-base.httpRequest",
      "position": [
        880,
        544
      ],
      "parameters": {
        "url": "https://api.wavespeed.ai/api/v3/bytedance/seedance-v1-pro-t2v-480p",
        "method": "POST",
        "options": {
          "batching": {
            "batch": {
              "batchSize": 1,
              "batchInterval": 3000
            }
          }
        },
        "jsonBody": "={\n  \"aspect_ratio\": \"9:16\",\n  \"duration\": 10,\n  \"prompt\": \"VIDEO THEME: {{$('Generate Detailed Video Prompts').item.json.output.Idea}} | WHAT HAPPENS IN THE VIDEO: {{$json.description}} | WHERE THE VIDEO IS SHOT: {{$('Generate Detailed Video Prompts').item.json.output.Environment}}\"\n}\n",
        "sendBody": true,
        "specifyBody": "json",
        "authentication": "genericCredentialType",
        "genericAuthType": "httpHeaderAuth"
      },
      "credentials": {
        "httpHeaderAuth": {
          "id": "QhpKhFJMiQAReugp",
          "name": "Header Auth account 4"
        }
      },
      "typeVersion": 4.2
    },
    {
      "id": "6c89b710-f5b6-43d8-b5d6-19ee65a21178",
      "name": "Upload Video to BLOTATO",
      "type": "@blotato/n8n-nodes-blotato.blotato",
      "position": [
        688,
        1568
      ],
      "parameters": {
        "mediaUrl": "={{ $json.final_output }}",
        "resource": "media"
      },
      "credentials": {
        "blotatoApi": {
          "id": "NtMnRSKAAN5u9lyc",
          "name": "Blotato account"
        }
      },
      "typeVersion": 2
    },
    {
      "id": "dc0d81e5-e79f-4cac-8f70-2f3cb0245a4f",
      "name": "Youtube",
      "type": "@blotato/n8n-nodes-blotato.blotato",
      "position": [
        1504,
        1360
      ],
      "parameters": {
        "options": {},
        "platform": "youtube",
        "accountId": {
          "__rl": true,
          "mode": "list",
          "value": "8047",
          "cachedResultUrl": "https://backend.blotato.com/v2/accounts/8047",
          "cachedResultName": "DR FIRASS (Dr. Firas)"
        },
        "postContentText": "={{ $('Save Idea & Metadata to Google Sheets').first().json.caption }}",
        "postContentMediaUrls": "={{ $json.url }}",
        "postCreateYoutubeOptionTitle": "={{ $('Save Idea & Metadata to Google Sheets').first().json.idea }}",
        "postCreateYoutubeOptionPrivacyStatus": "private",
        "postCreateYoutubeOptionShouldNotifySubscribers": false
      },
      "credentials": {
        "blotatoApi": {
          "id": "NtMnRSKAAN5u9lyc",
          "name": "Blotato account"
        }
      },
      "typeVersion": 2
    },
    {
      "id": "72b01b16-ec37-4213-b373-61ff189be5ce",
      "name": "Tiktok",
      "type": "@blotato/n8n-nodes-blotato.blotato",
      "position": [
        1136,
        1184
      ],
      "parameters": {
        "options": {},
        "platform": "tiktok",
        "accountId": {
          "__rl": true,
          "mode": "list",
          "value": "2079",
          "cachedResultUrl": "https://backend.blotato.com/v2/accounts/2079",
          "cachedResultName": "elitecybzcs"
        },
        "postContentText": "={{ $('Save Idea & Metadata to Google Sheets').first().json.caption }}",
        "postContentMediaUrls": "={{ $json.url }}"
      },
      "credentials": {
        "blotatoApi": {
          "id": "NtMnRSKAAN5u9lyc",
          "name": "Blotato account"
        }
      },
      "typeVersion": 2
    },
    {
      "id": "ecefa11f-55e1-47ca-8f1a-6e8fc4a6e1da",
      "name": "Merge",
      "type": "n8n-nodes-base.merge",
      "position": [
        1792,
        1264
      ],
      "parameters": {
        "mode": "chooseBranch",
        "numberInputs": 9
      },
      "typeVersion": 3.2
    },
    {
      "id": "9b1c4354-4710-4e01-bc39-357da758fc1e",
      "name": "Update Status to \"DONE\"",
      "type": "n8n-nodes-base.googleSheets",
      "position": [
        1968,
        1376
      ],
      "parameters": {
        "columns": {
          "value": {
            "idea": "={{ $('Save Idea & Metadata to Google Sheets').first().json.idea }}",
            "production": "Publish"
          },
          "schema": [
            {
              "id": "id",
              "type": "string",
              "display": true,
              "removed": true,
              "required": false,
              "displayName": "id",
              "defaultMatch": true,
              "canBeUsedToMatch": true
            },
            {
              "id": "idea",
              "type": "string",
              "display": true,
              "removed": false,
              "required": false,
              "displayName": "idea",
              "defaultMatch": false,
              "canBeUsedToMatch": true
            },
            {
              "id": "caption",
              "type": "string",
              "display": true,
              "removed": true,
              "required": false,
              "displayName": "caption",
              "defaultMatch": false,
              "canBeUsedToMatch": true
            },
            {
              "id": "production",
              "type": "string",
              "display": true,
              "removed": false,
              "required": false,
              "displayName": "production",
              "defaultMatch": false,
              "canBeUsedToMatch": true
            },
            {
              "id": "environment_prompt",
              "type": "string",
              "display": true,
              "removed": true,
              "required": false,
              "displayName": "environment_prompt",
              "defaultMatch": false,
              "canBeUsedToMatch": true
            },
            {
              "id": "sound_prompt",
              "type": "string",
              "display": true,
              "removed": true,
              "required": false,
              "displayName": "sound_prompt",
              "defaultMatch": false,
              "canBeUsedToMatch": true
            },
            {
              "id": "final_output",
              "type": "string",
              "display": true,
              "removed": true,
              "required": false,
              "displayName": "final_output",
              "defaultMatch": false,
              "canBeUsedToMatch": true
            }
          ],
          "mappingMode": "defineBelow",
          "matchingColumns": [
            "idea"
          ],
          "attemptToConvertTypes": false,
          "convertFieldsToString": false
        },
        "options": {},
        "operation": "appendOrUpdate",
        "sheetName": {
          "__rl": true,
          "mode": "id",
          "value": "="
        },
        "documentId": {
          "__rl": true,
          "mode": "id",
          "value": "="
        }
      },
      "credentials": {
        "googleSheetsOAuth2Api": {
          "id": "51us92xkOlrvArhV",
          "name": "Google Sheets account"
        }
      },
      "typeVersion": 4.5
    },
    {
      "id": "aa5e2e2a-4796-4227-acbc-f35ed12d1f84",
      "name": "Linkedin",
      "type": "@blotato/n8n-nodes-blotato.blotato",
      "position": [
        1328,
        1184
      ],
      "parameters": {
        "options": {},
        "platform": "linkedin",
        "accountId": {
          "__rl": true,
          "mode": "list",
          "value": "1446",
          "cachedResultUrl": "https://backend.blotato.com/v2/accounts/1446",
          "cachedResultName": "Samuel Amalric"
        },
        "postContentText": "={{ $('Save Idea & Metadata to Google Sheets').first().json.caption }}",
        "postContentMediaUrls": "={{ $json.url }}"
      },
      "credentials": {
        "blotatoApi": {
          "id": "NtMnRSKAAN5u9lyc",
          "name": "Blotato account"
        }
      },
      "typeVersion": 2
    },
    {
      "id": "0e0bf2c4-fba7-47f8-976b-8ac59e7e7c2a",
      "name": "Facebook",
      "type": "@blotato/n8n-nodes-blotato.blotato",
      "position": [
        1504,
        1184
      ],
      "parameters": {
        "options": {},
        "platform": "facebook",
        "accountId": {
          "__rl": true,
          "mode": "list",
          "value": "1759",
          "cachedResultUrl": "https://backend.blotato.com/v2/accounts/1759",
          "cachedResultName": "Firass Ben"
        },
        "facebookPageId": {
          "__rl": true,
          "mode": "list",
          "value": "101603614680195",
          "cachedResultUrl": "https://backend.blotato.com/v2/accounts/1759/subaccounts/101603614680195",
          "cachedResultName": "Dr. Firas"
        },
        "postContentText": "={{ $('Save Idea & Metadata to Google Sheets').first().json.caption }}",
        "postContentMediaUrls": "={{ $json.url }}"
      },
      "credentials": {
        "blotatoApi": {
          "id": "NtMnRSKAAN5u9lyc",
          "name": "Blotato account"
        }
      },
      "typeVersion": 2
    },
    {
      "id": "e7c07757-8d72-41bd-bb00-da0faed38e8a",
      "name": "Instagram",
      "type": "@blotato/n8n-nodes-blotato.blotato",
      "position": [
        1136,
        1360
      ],
      "parameters": {
        "options": {},
        "accountId": {
          "__rl": true,
          "mode": "list",
          "value": "11892",
          "cachedResultUrl": "https://backend.blotato.com/v2/accounts/11892",
          "cachedResultName": "doc.firass"
        },
        "postContentText": "={{ $('Save Idea & Metadata to Google Sheets').first().json.caption }}",
        "postContentMediaUrls": "={{ $json.url }}"
      },
      "credentials": {
        "blotatoApi": {
          "id": "NtMnRSKAAN5u9lyc",
          "name": "Blotato account"
        }
      },
      "typeVersion": 2
    },
    {
      "id": "d2e3223b-8355-42e1-a145-fbf6888725ef",
      "name": "Threads",
      "type": "@blotato/n8n-nodes-blotato.blotato",
      "position": [
        1136,
        1568
      ],
      "parameters": {
        "options": {},
        "platform": "threads",
        "accountId": {
          "__rl": true,
          "mode": "list",
          "value": "2280",
          "cachedResultUrl": "https://backend.blotato.com/v2/accounts/2280",
          "cachedResultName": "doc.firass"
        },
        "postContentText": "={{ $('Save Idea & Metadata to Google Sheets').first().json.caption }}",
        "postContentMediaUrls": "={{ $json.url }}"
      },
      "credentials": {
        "blotatoApi": {
          "id": "NtMnRSKAAN5u9lyc",
          "name": "Blotato account"
        }
      },
      "typeVersion": 2
    },
    {
      "id": "03ef5dad-624d-49fa-85f8-767bdcd3f5ac",
      "name": "Bluesky",
      "type": "@blotato/n8n-nodes-blotato.blotato",
      "position": [
        1328,
        1568
      ],
      "parameters": {
        "options": {},
        "platform": "bluesky",
        "accountId": {
          "__rl": true,
          "mode": "list",
          "value": "6012",
          "cachedResultUrl": "https://backend.blotato.com/v2/accounts/6012",
          "cachedResultName": "formationinternet.bsky.social"
        },
        "postContentText": "={{ $('Save Idea & Metadata to Google Sheets').first().json.caption }}",
        "postContentMediaUrls": "={{ $json.url }}"
      },
      "credentials": {
        "blotatoApi": {
          "id": "NtMnRSKAAN5u9lyc",
          "name": "Blotato account"
        }
      },
      "typeVersion": 2
    },
    {
      "id": "cdf84688-a254-4288-9cbc-b5c66f09cea0",
      "name": "Pinterest",
      "type": "@blotato/n8n-nodes-blotato.blotato",
      "position": [
        1504,
        1568
      ],
      "parameters": {
        "options": {},
        "platform": "pinterest",
        "accountId": {
          "__rl": true,
          "mode": "list",
          "value": "363",
          "cachedResultUrl": "https://backend.blotato.com/v2/accounts/363",
          "cachedResultName": "formationinternet2022"
        },
        "postContentText": "={{ $('Save Idea & Metadata to Google Sheets').first().json.caption }}",
        "pinterestBoardId": {
          "__rl": true,
          "mode": "id",
          "value": "1146658823815436667"
        },
        "postContentMediaUrls": "={{ $json.url }}"
      },
      "credentials": {
        "blotatoApi": {
          "id": "NtMnRSKAAN5u9lyc",
          "name": "Blotato account"
        }
      },
      "typeVersion": 2
    },
    {
      "id": "9576e941-bd26-4b47-ae0d-4ec50350d9a3",
      "name": "Twitter (X)",
      "type": "@blotato/n8n-nodes-blotato.blotato",
      "position": [
        1328,
        1360
      ],
      "parameters": {
        "options": {},
        "platform": "twitter",
        "accountId": {
          "__rl": true,
          "mode": "list",
          "value": "1289",
          "cachedResultUrl": "https://backend.blotato.com/v2/accounts/1289",
          "cachedResultName": "Docteur_Firas"
        },
        "postContentText": "={{ $('Save Idea & Metadata to Google Sheets').first().json.caption }}",
        "postContentMediaUrls": "={{ $json.url }}"
      },
      "credentials": {
        "blotatoApi": {
          "id": "NtMnRSKAAN5u9lyc",
          "name": "Blotato account"
        }
      },
      "typeVersion": 2
    },
    {
      "id": "3912175b-5ccd-4b8e-8092-943ee7952434",
      "name": "LLM: Generate Raw Idea (GPT-5)",
      "type": "@n8n/n8n-nodes-langchain.lmChatOpenAi",
      "position": [
        912,
        288
      ],
      "parameters": {
        "model": {
          "__rl": true,
          "mode": "list",
          "value": "gpt-5-mini",
          "cachedResultName": "gpt-5-mini"
        },
        "options": {}
      },
      "credentials": {
        "openAiApi": {
          "id": "6h3DfVhNPw9I25nO",
          "name": "OpenAi account"
        }
      },
      "typeVersion": 1.2
    }
  ],
  "active": false,
  "pinData": {},
  "settings": {
    "executionOrder": "v1"
  },
  "versionId": "527f2751-2d7e-4749-87ed-7df50bb3da1b",
  "connections": {
    "Merge": {
      "main": [
        [
          {
            "node": "Update Status to \"DONE\"",
            "type": "main",
            "index": 0
          }
        ]
      ]
    },
    "Tiktok": {
      "main": [
        [
          {
            "node": "Merge",
            "type": "main",
            "index": 0
          }
        ]
      ]
    },
    "Bluesky": {
      "main": [
        [
          {
            "node": "Merge",
            "type": "main",
            "index": 7
          }
        ]
      ]
    },
    "Threads": {
      "main": [
        [
          {
            "node": "Merge",
            "type": "main",
            "index": 6
          }
        ]
      ]
    },
    "Youtube": {
      "main": [
        [
          {
            "node": "Merge",
            "type": "main",
            "index": 5
          }
        ]
      ]
    },
    "Facebook": {
      "main": [
        [
          {
            "node": "Merge",
            "type": "main",
            "index": 2
          }
        ]
      ]
    },
    "Linkedin": {
      "main": [
        [
          {
            "node": "Merge",
            "type": "main",
            "index": 1
          }
        ]
      ]
    },
    "Instagram": {
      "main": [
        [
          {
            "node": "Merge",
            "type": "main",
            "index": 3
          }
        ]
      ]
    },
    "Pinterest": {
      "main": [
        [
          {
            "node": "Merge",
            "type": "main",
            "index": 8
          }
        ]
      ]
    },
    "Twitter (X)": {
      "main": [
        [
          {
            "node": "Merge",
            "type": "main",
            "index": 4
          }
        ]
      ]
    },
    "URL Final Video": {
      "main": [
        [
          {
            "node": "Upload Video to BLOTATO",
            "type": "main",
            "index": 0
          }
        ]
      ]
    },
    "Retrieve Video Clips": {
      "main": [
        [
          {
            "node": "Generate ASMR Sound (Fal AI)",
            "type": "main",
            "index": 0
          }
        ]
      ]
    },
    "Update Status to \"DONE\"": {
      "main": [
        []
      ]
    },
    "Upload Video to BLOTATO": {
      "main": [
        [
          {
            "node": "Tiktok",
            "type": "main",
            "index": 0
          },
          {
            "node": "Linkedin",
            "type": "main",
            "index": 0
          },
          {
            "node": "Facebook",
            "type": "main",
            "index": 0
          },
          {
            "node": "Instagram",
            "type": "main",
            "index": 0
          },
          {
            "node": "Twitter (X)",
            "type": "main",
            "index": 0
          },
          {
            "node": "Youtube",
            "type": "main",
            "index": 0
          },
          {
            "node": "Threads",
            "type": "main",
            "index": 0
          },
          {
            "node": "Bluesky",
            "type": "main",
            "index": 0
          },
          {
            "node": "Pinterest",
            "type": "main",
            "index": 0
          }
        ]
      ]
    },
    "Retrieve Final Merged Video": {
      "main": [
        [
          {
            "node": "URL Final Video",
            "type": "main",
            "index": 0
          }
        ]
      ]
    },
    "Retrieve Final Sound Output": {
      "main": [
        [
          {
            "node": "List Clip URLs for Stitching",
            "type": "main",
            "index": 0
          }
        ]
      ]
    },
    "Generate ASMR Sound (Fal AI)": {
      "main": [
        [
          {
            "node": "Wait for Sound Generation (Fal AI)",
            "type": "main",
            "index": 0
          }
        ]
      ]
    },
    "Generate Creative Video Idea": {
      "main": [
        [
          {
            "node": "Save Idea & Metadata to Google Sheets",
            "type": "main",
            "index": 0
          }
        ]
      ]
    },
    "List Clip URLs for Stitching": {
      "main": [
        [
          {
            "node": "Merge Clips into Final Video (Fal AI)",
            "type": "main",
            "index": 0
          }
        ]
      ]
    },
    "LLM: Generate Raw Idea (GPT-5)": {
      "ai_languageModel": [
        [
          {
            "node": "Generate Creative Video Idea",
            "type": "ai_languageModel",
            "index": 0
          }
        ]
      ]
    },
    "Generate Detailed Video Prompts": {
      "main": [
        [
          {
            "node": "Extract Individual Scene Descriptions",
            "type": "main",
            "index": 0
          }
        ]
      ]
    },
    "Generate Video Clips (seedance)": {
      "main": [
        [
          {
            "node": "Wait for Clip Generation (Wavespeed AI)",
            "type": "main",
            "index": 0
          }
        ]
      ]
    },
    "Wait for Video Rendering (Fal AI)": {
      "main": [
        [
          {
            "node": "Retrieve Final Merged Video",
            "type": "main",
            "index": 0
          }
        ]
      ]
    },
    "Tool: Refine and Validate Prompts1": {
      "ai_tool": [
        [
          {
            "node": "Generate Detailed Video Prompts",
            "type": "ai_tool",
            "index": 0
          }
        ]
      ]
    },
    "Wait for Sound Generation (Fal AI)": {
      "main": [
        [
          {
            "node": "Retrieve Final Sound Output",
            "type": "main",
            "index": 0
          }
        ]
      ]
    },
    "Parse Structured Video Prompt Output": {
      "ai_outputParser": [
        [
          {
            "node": "Generate Detailed Video Prompts",
            "type": "ai_outputParser",
            "index": 0
          }
        ]
      ]
    },
    "Extract Individual Scene Descriptions": {
      "main": [
        [
          {
            "node": "Generate Video Clips (seedance)",
            "type": "main",
            "index": 0
          }
        ]
      ]
    },
    "Merge Clips into Final Video (Fal AI)": {
      "main": [
        [
          {
            "node": "Wait for Video Rendering (Fal AI)",
            "type": "main",
            "index": 0
          }
        ]
      ]
    },
    "Save Idea & Metadata to Google Sheets": {
      "main": [
        [
          {
            "node": "Generate Detailed Video Prompts",
            "type": "main",
            "index": 0
          }
        ]
      ]
    },
    "Trigger: Start Daily Content Generation": {
      "main": [
        [
          {
            "node": "Generate Creative Video Idea",
            "type": "main",
            "index": 0
          }
        ]
      ]
    },
    "Wait for Clip Generation (Wavespeed AI)": {
      "main": [
        [
          {
            "node": "Retrieve Video Clips",
            "type": "main",
            "index": 0
          }
        ]
      ]
    },
    "Tool: Inject Creative Perspective (Idea)": {
      "ai_tool": [
        [
          {
            "node": "Generate Creative Video Idea",
            "type": "ai_tool",
            "index": 0
          }
        ]
      ]
    },
    "LLM: Draft Video Prompt Details (GPT-4.1)": {
      "ai_languageModel": [
        [
          {
            "node": "Generate Detailed Video Prompts",
            "type": "ai_languageModel",
            "index": 0
          }
        ]
      ]
    },
    "Parse AI Output (Idea, Environment, Sound)": {
      "ai_outputParser": [
        [
          {
            "node": "Generate Creative Video Idea",
            "type": "ai_outputParser",
            "index": 0
          }
        ]
      ]
    }
  }
}
```
</details>