# 🎓 Learn n8n Expressions with an Interactive Step-by-Step Tutorial for Beginners
> **Category**: Data Processing & Analysis
> **Views**: 27,902
> **Created**: 6/24/2025
## Description
How it works

This template is an interactive, step-by-step tutorial designed to teach you the most important skill in n8n: using expressions to access and manipulate data.

If you know what JSON is but aren't sure how to pull a specific piece of information from one node and use it in another, this workflow is for you. It starts with a single "Source Data" node that acts as our filing cabinet, and then walks you through a series of lessons, each demonstrating a new technique for retrieving and transforming that data.

You will learn how to:
Access a simple value from a previous node.
Use n8n's built-in selectors like .last() and .first().
Get a specific item from a list (Array).
Drill down into nested data (Objects).
Combine these techniques to access data in an array of objects.
Go beyond simple retrieval by using JavaScript functions to do math or change text.
Inspect data with utility functions like Object.keys() and JSON.stringify().
Summarize data from multiple items using .all() and arrow functions.

Set up steps

Setup time: 0 minutes!

This workflow is a self-contained tutorial and requires no setup or external credentials.

Click "Execute Workflow" to run the entire tutorial.
Follow the flow from the "Source Data" node to the "Final Exam" node.
For each lesson, click on the node to see how its expressions are configured in the parameters panel.
Read the detailed sticky note next to each lesson—it breaks down exactly how the expression works and why.

By the end, you'll have the foundational knowledge to connect data and build powerful, dynamic workflows in n8n.
## Workflow Structure
# 🎓 Learn n8n Expressions with an Interactive Step-by-Step Tutorial for Beginners

## Basic Information

- Node count: 13
- Connection count: 12

## Key Nodes

### Triggers
- Start Tutorial (`n8n-nodes-base.manualTrigger`)

## All Nodes

| Node Name | Type | Category |
|-----------|------|----------|
| Start Tutorial | `n8n-nodes-base.manualTrigger` | Trigger |
| Source Data | `n8n-nodes-base.set` | Transform |
| 1. The Basics | `n8n-nodes-base.set` | Transform |
| 3. Working with Arrays | `n8n-nodes-base.set` | Transform |
| 4. Going Deeper | `n8n-nodes-base.set` | Transform |
| 5. The Combo Move | `n8n-nodes-base.set` | Transform |
| 6. A Touch of Magic | `n8n-nodes-base.set` | Transform |
| 9. The "All Items" View | `n8n-nodes-base.set` | Transform |
| Final Exam | `n8n-nodes-base.set` | Transform |
| 2. The n8n Selectors | `n8n-nodes-base.set` | Transform |
| 7. Inspecting Objects | `n8n-nodes-base.set` | Transform |
| 8. Utility Functions | `n8n-nodes-base.set` | Transform |
| Split Out Skills | `n8n-nodes-base.splitOut` | Other |

## Connections

```
Source Data --[main]--> 1. The Basics
1. The Basics --[main]--> 2. The n8n Selectors
Start Tutorial --[main]--> Source Data
4. Going Deeper --[main]--> 5. The Combo Move
Split Out Skills --[main]--> 9. The "All Items" View
5. The Combo Move --[main]--> 6. A Touch of Magic
6. A Touch of Magic --[main]--> 7. Inspecting Objects
2. The n8n Selectors --[main]--> 3. Working with Arrays
8. Utility Functions --[main]--> Split Out Skills
7. Inspecting Objects --[main]--> 8. Utility Functions
3. Working with Arrays --[main]--> 4. Going Deeper
9. The "All Items" View --[main]--> Final Exam
```

## Workflow Summary

This workflow is triggered by Start Tutorial, goes through 11 transformation step(s).
## Author Information
- **Name**: Lucas Peyrin
- **Username**: @lucaspeyrin
- Verified user
## Related Links
- [View this template on n8n.io](https://n8n.io/workflows/5271)
## Complete Workflow JSON
<details>
<summary>Click to expand Workflow JSON</summary>
```json
{
  "meta": {
    "creator": "Lucas Peyrin",
    "instanceId": "e409ea34548a2afe2dffba31130cd1cf2e98ebe2afaeed2a63caf2a0582d1da0",
    "fingerprint": "eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJjcmVhdG9yIjoiIiwiaXNzIjoibjhuIiwiaWF0IjoxNzUzMTEwNzQyfQ.22NSzq8u2n90V1pTm2nufo-wYBcjQDKoAJuTz0ouwU8"
  },
  "nodes": [
    {
      "id": "2c20bdef-e54e-46ab-9c63-5cf521ec749e",
      "cid": "Ikx1Y2FzIFBleXJpbiI",
      "name": "Start Tutorial",
      "type": "n8n-nodes-base.manualTrigger",
      "notes": "© 2025 Lucas Peyrin",
      "creator": "Lucas Peyrin",
      "position": [
        -7360,
        992
      ],
      "parameters": {},
      "typeVersion": 1
    },
    {
      "id": "25703548-3e48-4951-9e3b-1d7815e15af5",
      "cid": "Ikx1Y2FzIFBleXJpbiI",
      "name": "Sticky Note",
      "type": "n8n-nodes-base.stickyNote",
      "notes": "© 2025 Lucas Peyrin",
      "creator": "Lucas Peyrin",
      "position": [
        -7616,
        592
      ],
      "parameters": {
        "color": 5,
        "width": 640,
        "height": 560,
        "content": "# Tutorial - Mastering n8n Expressions\n\nWelcome! You know what JSON is. Now, let's learn how to **use it**. This workflow teaches you how to pull data from one node and use it in another using n8n's powerful expressions.\n\n**What is an Expression?**\nAn expression is a small piece of code inside double curly braces `{{ }}` that gets replaced with a dynamic value when the workflow runs. It's the \"glue\" that connects your nodes.\n\n**How to use this tutorial:**\n1.  The first node, **\"Source Data\"**, contains all the data we will use. Execute it once to see what's inside.\n2.  Follow the path from top to bottom. Each node is a new lesson.\n3.  Read the sticky note for each lesson, then look at the node's configuration and its output to understand the concept."
      },
      "typeVersion": 1
    },
    {
      "id": "b875f86c-a790-49bc-96a0-e1ccc72a5e80",
      "cid": "Ikx1Y2FzIFBleXJpbiI",
      "name": "Source Data",
      "type": "n8n-nodes-base.set",
      "notes": "© 2025 Lucas Peyrin",
      "creator": "Lucas Peyrin",
      "position": [
        -6720,
        992
      ],
      "parameters": {
        "options": {},
        "assignments": {
          "assignments": [
            {
              "id": "12345",
              "name": "name",
              "type": "string",
              "value": "Alice"
            },
            {
              "id": "67890",
              "name": "age",
              "type": "number",
              "value": 30
            },
            {
              "id": "abcde",
              "name": "is_active",
              "type": "boolean",
              "value": true
            },
            {
              "id": "fghij",
              "name": "skills",
              "type": "array",
              "value": "[\"JavaScript\",\"Python\",\"n8n\"]"
            },
            {
              "id": "klmno",
              "name": "projects",
              "type": "array",
              "value": "[{\"name\":\"Project A\",\"status\":\"Done\"},{\"name\":\"Project B\",\"status\":\"In Progress\"}]"
            },
            {
              "id": "pqrst",
              "name": "contact",
              "type": "object",
              "value": "{\"email\":\"alice@example.com\",\"phone\":null}"
            }
          ]
        }
      },
      "typeVersion": 3.4
    },
    {
      "id": "108d6d9a-6e98-491d-87c1-78d3680f0c40",
      "cid": "Ikx1Y2FzIFBleXJpbiI",
      "name": "Sticky Note1",
      "type": "n8n-nodes-base.stickyNote",
      "notes": "© 2025 Lucas Peyrin",
      "creator": "Lucas Peyrin",
      "position": [
        -6944,
        640
      ],
      "parameters": {
        "color": 7,
        "width": 520,
        "height": 520,
        "content": "## Our Data Source\n\nThis node holds all the sample data for our tutorial. Think of it as a filing cabinet. All the other nodes will be reaching into this cabinet to pull out specific pieces of information.\n\nTake a look at its output to familiarize yourself with the structure.\nWe have:\n- Simple text (`name`)\n- A number (`age`)\n- A list of skills (`skills`)\n- A list of complex projects (`projects`)\n- A nested contact object (`contact`)"
      },
      "typeVersion": 1
    },
    {
      "id": "54723ed3-94c5-4104-b1c5-3ac70c262b87",
      "cid": "Ikx1Y2FzIFBleXJpbiI",
      "name": "1. The Basics",
      "type": "n8n-nodes-base.set",
      "notes": "© 2025 Lucas Peyrin",
      "creator": "Lucas Peyrin",
      "position": [
        -6192,
        992
      ],
      "parameters": {
        "options": {},
        "assignments": {
          "assignments": [
            {
              "id": "12345",
              "name": "user_name",
              "type": "string",
              "value": "={{ $('Source Data').item.json.name }}"
            }
          ]
        }
      },
      "typeVersion": 3.4
    },
    {
      "id": "81dc9611-b9b5-41c3-a5ab-460cb0dc1ca6",
      "cid": "Ikx1Y2FzIFBleXJpbiI",
      "name": "Sticky Note2",
      "type": "n8n-nodes-base.stickyNote",
      "notes": "© 2025 Lucas Peyrin",
      "creator": "Lucas Peyrin",
      "position": [
        -6400,
        576
      ],
      "parameters": {
        "color": 2,
        "width": 500,
        "height": 580,
        "content": "## Lesson 1: Accessing a Simple Value\n\nThis is the most common thing you'll do in n8n.\n\n**The Goal:** Get the user's name from the \"Source Data\" node.\n\n**The Expression:** `{{ $('Source Data').item.json.name }}`\n\n**Breakdown:**\n- `{{ ... }}`: Tells n8n \"this is a dynamic expression\".\n- `$('Source Data')`: Selects the node we want data from.\n- `.item.json`: Narrows it down to the JSON data of the current item.\n- `.name`: Selects the specific **key** we want the value of.\n\n**Other Possibility:**\n`{{ $json.name }}` would also work in this case, as `$json` accesses the data from the previous node."
      },
      "typeVersion": 1
    },
    {
      "id": "b91f6099-5207-4000-9a0e-e6374718c123",
      "cid": "Ikx1Y2FzIFBleXJpbiI",
      "name": "3. Working with Arrays",
      "type": "n8n-nodes-base.set",
      "notes": "© 2025 Lucas Peyrin",
      "creator": "Lucas Peyrin",
      "position": [
        -4960,
        992
      ],
      "parameters": {
        "options": {},
        "assignments": {
          "assignments": [
            {
              "id": "12345",
              "name": "second_skill",
              "type": "string",
              "value": "={{ $('Source Data').last().json.skills[1] }}"
            }
          ]
        }
      },
      "typeVersion": 3.4
    },
    {
      "id": "2074d65b-2d6b-41af-a4f9-fa9a195a1bf8",
      "cid": "Ikx1Y2FzIFBleXJpbiI",
      "name": "Sticky Note3",
      "type": "n8n-nodes-base.stickyNote",
      "notes": "© 2025 Lucas Peyrin",
      "creator": "Lucas Peyrin",
      "position": [
        -5168,
        624
      ],
      "parameters": {
        "color": 4,
        "width": 540,
        "height": 520,
        "content": "## Lesson 3: Accessing an Array Element\n\nWhat if the data is in a list (an array)? You need to specify *which* item you want.\n\n**The Goal:** Get the user's *second* skill.\n\n**The Expression:** `{{ $('Source Data').last().json.skills[1] }}`\n\n**Breakdown:**\n- `...skills`: Selects the array of skills.\n- `[1]`: Selects the item at a specific position.\n- **IMPORTANT:** Arrays are \"zero-indexed\", which means the first item is `[0]`, the second is `[1]`, the third is `[2]`, and so on."
      },
      "typeVersion": 1
    },
    {
      "id": "8ccc139f-0e8c-4c25-9d04-cecf2b335934",
      "cid": "Ikx1Y2FzIFBleXJpbiI",
      "name": "4. Going Deeper",
      "type": "n8n-nodes-base.set",
      "notes": "© 2025 Lucas Peyrin",
      "creator": "Lucas Peyrin",
      "position": [
        -4400,
        992
      ],
      "parameters": {
        "options": {},
        "assignments": {
          "assignments": [
            {
              "id": "12345",
              "name": "user_email",
              "type": "string",
              "value": "={{ $('Source Data').last().json.contact.email }}"
            }
          ]
        }
      },
      "typeVersion": 3.4
    },
    {
      "id": "34264c0c-8282-4b57-a066-0548a31cbf1a",
      "cid": "Ikx1Y2FzIFBleXJpbiI",
      "name": "Sticky Note4",
      "type": "n8n-nodes-base.stickyNote",
      "notes": "© 2025 Lucas Peyrin",
      "creator": "Lucas Peyrin",
      "position": [
        -4608,
        672
      ],
      "parameters": {
        "color": 5,
        "width": 540,
        "height": 480,
        "content": "## Lesson 4: Accessing Nested Data\n\nSometimes, data is organized into objects within other objects.\n\n**The Goal:** Get the user's email address.\n\n**The Expression:** `{{ $('Source Data').last().json.contact.email }}`\n\n**Breakdown:**\n- `...contact`: First, we access the `contact` object.\n- `.email`: Then, we use another dot `.` to go one level deeper and get the value of the `email` key inside it."
      },
      "typeVersion": 1
    },
    {
      "id": "4c41fb6a-5f93-408f-9583-1e118d139dcf",
      "cid": "Ikx1Y2FzIFBleXJpbiI",
      "name": "5. The Combo Move",
      "type": "n8n-nodes-base.set",
      "notes": "© 2025 Lucas Peyrin",
      "creator": "Lucas Peyrin",
      "position": [
        -3808,
        992
      ],
      "parameters": {
        "options": {},
        "assignments": {
          "assignments": [
            {
              "id": "12345",
              "name": "first_project_status",
              "type": "string",
              "value": "={{ $('Source Data').last().json.projects[0].status }}"
            }
          ]
        }
      },
      "typeVersion": 3.4
    },
    {
      "id": "2123cd02-5cb6-4dd7-89e5-7af1c6edf234",
      "cid": "Ikx1Y2FzIFBleXJpbiI",
      "name": "Sticky Note5",
      "type": "n8n-nodes-base.stickyNote",
      "notes": "© 2025 Lucas Peyrin",
      "creator": "Lucas Peyrin",
      "position": [
        -4048,
        672
      ],
      "parameters": {
        "color": 6,
        "width": 580,
        "height": 480,
        "content": "## Lesson 5: Accessing Data in an Array of Objects\n\nThis is the ultimate test of the previous lessons!\n\n**The Goal:** Get the *status* of the *first* project in the list.\n\n**The Expression:** `{{ $('Source Data').last().json.projects[0].status }}`\n\n**Breakdown:**\n1.  `...projects`: We select the array of projects.\n2.  `[0]`: We pick the first object in that array.\n3.  `.status`: From that chosen object, we grab the value of the `status` key."
      },
      "typeVersion": 1
    },
    {
      "id": "f25a5a9d-518d-4a4a-b2ad-36fd0e1f5bd2",
      "cid": "Ikx1Y2FzIFBleXJpbiI",
      "name": "6. A Touch of Magic",
      "type": "n8n-nodes-base.set",
      "notes": "© 2025 Lucas Peyrin",
      "creator": "Lucas Peyrin",
      "position": [
        -3200,
        992
      ],
      "parameters": {
        "options": {},
        "assignments": {
          "assignments": [
            {
              "id": "12345",
              "name": "name_in_caps",
              "type": "string",
              "value": "={{ $('Source Data').last().json.name.toUpperCase() }}"
            },
            {
              "id": "67890",
              "name": "age_in_dog_years",
              "type": "number",
              "value": "={{ Math.round($('Source Data').last().json.age / 7) }}"
            },
            {
              "id": "abcde",
              "name": "age_data_type",
              "type": "string",
              "value": "={{ typeof $('Source Data').last().json.age }}"
            }
          ]
        }
      },
      "typeVersion": 3.4
    },
    {
      "id": "0ebf5e6b-feb8-4f32-9979-9d7555b461ed",
      "cid": "Ikx1Y2FzIFBleXJpbiI",
      "name": "Sticky Note6",
      "type": "n8n-nodes-base.stickyNote",
      "notes": "© 2025 Lucas Peyrin",
      "creator": "Lucas Peyrin",
      "position": [
        -3440,
        640
      ],
      "parameters": {
        "color": 3,
        "width": 580,
        "height": 520,
        "content": "## Lesson 6: A Touch of Magic (JS Functions)\n\nYou can do more than just retrieve data; you can **manipulate and inspect it!**\n\n**The Expressions:**\n- **Transform Text:** `{{ $('Source Data').last().json.name.toUpperCase() }}`\n- **Do Math:** `{{ Math.round($('Source Data').last().json.age / 7) }}`\n- **Check Data Type:** `{{ typeof $('Source Data').last().json.age }}`\n\n**Breakdown:**\n- **`.toUpperCase()`**: A standard JavaScript function for strings.\n- **`Math.round(...)`**: The `Math` object gives you access to powerful math functions.\n- **`typeof`**: An operator that tells you what kind of data you're looking at (\"string\", \"number\", \"object\", etc.)."
      },
      "typeVersion": 1
    },
    {
      "id": "81d8c2d6-95cc-47e3-b0f0-9c698a120d1c",
      "cid": "Ikx1Y2FzIFBleXJpbiI",
      "name": "9. The \"All Items\" View",
      "type": "n8n-nodes-base.set",
      "notes": "© 2025 Lucas Peyrin",
      "creator": "Lucas Peyrin",
      "position": [
        -1264,
        992
      ],
      "parameters": {
        "options": {},
        "assignments": {
          "assignments": [
            {
              "id": "12345",
              "name": "all_skills_string",
              "type": "string",
              "value": "={{ $('Split Out Skills').all().map(item => item.json.skills).join(', ') }}"
            }
          ]
        }
      },
      "executeOnce": true,
      "typeVersion": 3.4
    },
    {
      "id": "609e27f8-1702-493e-bc8b-cbade4561bd2",
      "cid": "Ikx1Y2FzIFBleXJpbiI",
      "name": "Sticky Note7",
      "type": "n8n-nodes-base.stickyNote",
      "notes": "© 2025 Lucas Peyrin",
      "creator": "Lucas Peyrin",
      "position": [
        -1696,
        640
      ],
      "parameters": {
        "color": 5,
        "width": 780,
        "height": 520,
        "content": "## Lesson 9: Working with Multiple Items (`$items` & Arrow Functions)\n\nWhat if a node outputs *multiple* items and you want to summarize them? `$items()` is your tool.\n\n**The Goal:** Get a single, comma-separated string of all the user's skills.\n\n**The Expression:** `{{ $('Split Out Skills').all().map(item `=>` item.json.skills).join(', ') }}`\n\n**What is `item => ...`?**\nThis is an **Arrow Function**, a shorthand for \"for each thing, do this\".\n- `item`: A temporary name for each item in the list as we loop over it.\n- =>: The \"arrow\" that separates the item from the action.\n- `item.json.skills`: The action to perform—in this case, get the skill value from the item."
      },
      "typeVersion": 1
    },
    {
      "id": "d6afc595-c6f0-47b2-894e-b03d6a0227ee",
      "cid": "Ikx1Y2FzIFBleXJpbiI",
      "name": "Final Exam",
      "type": "n8n-nodes-base.set",
      "notes": "© 2025 Lucas Peyrin",
      "creator": "Lucas Peyrin",
      "position": [
        -688,
        992
      ],
      "parameters": {
        "options": {},
        "assignments": {
          "assignments": [
            {
              "id": "12345",
              "name": "final_summary",
              "type": "string",
              "value": "=User {{ $('2. The n8n Selectors').last().json.user_name_from_first }} is {{ $('Source Data').last().json.age }}.\n\nTheir best skill is {{ $('3. Working with Arrays').last().json.second_skill }}.\n\nTheir first project was {{ $('Source Data').last().json.projects[0].name }}, which is now {{ $('5. The Combo Move').last().json.first_project_status }}.\n\nAll skills: {{ $('9. The \"All Items\" View').last().json.all_skills_string }}."
            }
          ]
        }
      },
      "typeVersion": 3.4
    },
    {
      "id": "99a7fb24-491c-436e-a775-6fabdc2c4004",
      "cid": "Ikx1Y2FzIFBleXJpbiI",
      "name": "Sticky Note8",
      "type": "n8n-nodes-base.stickyNote",
      "notes": "© 2025 Lucas Peyrin",
      "creator": "Lucas Peyrin",
      "position": [
        -896,
        736
      ],
      "parameters": {
        "color": 6,
        "width": 520,
        "height": 420,
        "content": "## 🎓 FINAL EXAM: Putting It All Together\n\nThis node uses everything we've learned to build a final summary object.\n\nLook at the expressions for each field. They pull data from different nodes and use different techniques you've just practiced.\n\n**Congratulations! You now have the foundational knowledge to link data and build powerful, dynamic workflows in n8n.**"
      },
      "typeVersion": 1
    },
    {
      "id": "c3f2fd66-784d-4675-8cb3-72dd33e6ee4e",
      "cid": "Ikx1Y2FzIFBleXJpbiI",
      "name": "2. The n8n Selectors",
      "type": "n8n-nodes-base.set",
      "notes": "© 2025 Lucas Peyrin",
      "creator": "Lucas Peyrin",
      "position": [
        -5568,
        992
      ],
      "parameters": {
        "options": {},
        "assignments": {
          "assignments": [
            {
              "id": "12345",
              "name": "user_name_from_first",
              "type": "string",
              "value": "={{ $('Source Data').last().json.name }}"
            }
          ]
        }
      },
      "typeVersion": 3.4
    },
    {
      "id": "bade9e22-6e9d-4f25-a1b7-974cbf2d5c61",
      "cid": "Ikx1Y2FzIFBleXJpbiI",
      "name": "Sticky Note9",
      "type": "n8n-nodes-base.stickyNote",
      "notes": "© 2025 Lucas Peyrin",
      "creator": "Lucas Peyrin",
      "position": [
        -5872,
        528
      ],
      "parameters": {
        "width": 680,
        "height": 620,
        "content": "## Lesson 2: The n8n Selectors (`.first()`, `.last()`, `.all()`)\n\nIn the last lesson, we used `.item`. When there is only one output item from a node, this is equivalent to `.last()`. Using `.last()` explicitly is often safer and clearer.\n\n**The Goal:** Get the user's name using the `.last()` selector.\n\n**The Expression:** `{{ $('Source Data').last().json.name }}`\n\n**Why is this better?**\nIf a node ever returns multiple items, `.last()` guarantees you only get data from the very last one.\n\nIf you ever need to match the selected data with the input items, this is where `.item` cannot be replaced.\n\n**Other Selectors:**\n- **`.first()`**: Gets the data from the first item.\n- **`.all()`**: Gets data from ALL items, returning it as an array of objects. (This is different from `$items`!)"
      },
      "typeVersion": 1
    },
    {
      "id": "7c4b718e-fca8-4dbe-8b3b-d6aeeaa78d6d",
      "cid": "Ikx1Y2FzIFBleXJpbiI",
      "name": "7. Inspecting Objects",
      "type": "n8n-nodes-base.set",
      "notes": "© 2025 Lucas Peyrin",
      "creator": "Lucas Peyrin",
      "position": [
        -2640,
        992
      ],
      "parameters": {
        "options": {},
        "assignments": {
          "assignments": [
            {
              "id": "12345",
              "name": "contact_keys",
              "type": "array",
              "value": "={{ Object.keys($('Source Data').last().json.contact) }}"
            }
          ]
        }
      },
      "typeVersion": 3.4
    },
    {
      "id": "089b02d1-e43b-4baf-8bcf-b2dd7a95df92",
      "cid": "Ikx1Y2FzIFBleXJpbiI",
      "name": "Sticky Note10",
      "type": "n8n-nodes-base.stickyNote",
      "notes": "© 2025 Lucas Peyrin",
      "creator": "Lucas Peyrin",
      "position": [
        -2832,
        640
      ],
      "parameters": {
        "color": 2,
        "width": 500,
        "height": 520,
        "content": "## Lesson 7: Inspecting Objects (`Object.keys()`)\n\nWhat if you have an object but you don't know what keys are inside it? `Object.keys()` comes to the rescue.\n\n**The Goal:** Get a list of all the keys inside the `contact` object.\n\n**The Expression:** `{{ Object.keys($('Source Data').last().json.contact) }}`\n\nThis is incredibly useful for dynamically processing data. It returns an **array** containing the names of the keys (e.g., `[\"email\", \"phone\"]`)."
      },
      "typeVersion": 1
    },
    {
      "id": "81a16f66-4fca-47af-841c-91e16ff9587e",
      "cid": "Ikx1Y2FzIFBleXJpbiI",
      "name": "8. Utility Functions",
      "type": "n8n-nodes-base.set",
      "notes": "© 2025 Lucas Peyrin",
      "creator": "Lucas Peyrin",
      "position": [
        -2064,
        992
      ],
      "parameters": {
        "options": {},
        "assignments": {
          "assignments": [
            {
              "id": "12345",
              "name": "contact_as_string",
              "type": "string",
              "value": "={{ JSON.stringify($('Source Data').last().json.contact, null, 2) }}"
            },
            {
              "id": "06003b65-7482-4d5a-b2c0-1794859ab461",
              "name": "skills",
              "type": "array",
              "value": "={{ $('Source Data').last().json.skills }}"
            }
          ]
        }
      },
      "typeVersion": 3.4
    },
    {
      "id": "b7aea910-5fd6-420f-9814-77afb8ab9517",
      "cid": "Ikx1Y2FzIFBleXJpbiI",
      "name": "Sticky Note11",
      "type": "n8n-nodes-base.stickyNote",
      "notes": "© 2025 Lucas Peyrin",
      "creator": "Lucas Peyrin",
      "position": [
        -2304,
        640
      ],
      "parameters": {
        "width": 580,
        "height": 520,
        "content": "## Lesson 8: Utility Functions (`JSON.stringify()`)\n\nSometimes you need to convert a structured JSON object back into a clean, single string. This is common when sending data to another service, like in an AI prompt.\n\n**The Goal:** Turn the entire `contact` object into a formatted string.\n\n**The Expression:** `{{ JSON.stringify($('Source Data').last().json.contact, null, 2) }}`\n\n**Breakdown:**\n- **`JSON.stringify(...)`**: The function that does the conversion.\n- **`null, 2`**: These optional parameters tell it to \"pretty-print\" the string with an indentation of 2 spaces, making it readable."
      },
      "typeVersion": 1
    },
    {
      "id": "2b83f9a2-7c71-43bb-b940-d0c3204cf6a2",
      "cid": "Ikx1Y2FzIFBleXJpbiI",
      "name": "Split Out Skills",
      "type": "n8n-nodes-base.splitOut",
      "notes": "© 2025 Lucas Peyrin",
      "creator": "Lucas Peyrin",
      "position": [
        -1488,
        992
      ],
      "parameters": {
        "include": "allOtherFields",
        "options": {},
        "fieldToSplitOut": "skills"
      },
      "typeVersion": 1
    },
    {
      "id": "933a0592-2deb-4db7-b801-d52dbbed1252",
      "cid": "Ikx1Y2FzIFBleXJpbiI",
      "name": "Sticky Note12",
      "type": "n8n-nodes-base.stickyNote",
      "notes": "© 2025 Lucas Peyrin",
      "creator": "Lucas Peyrin",
      "position": [
        -352,
        -128
      ],
      "parameters": {
        "color": 3,
        "width": 540,
        "height": 1280,
        "content": "## Was this helpful? Let me know!\n[![clic](https://supastudio.ia2s.app/storage/v1/object/public/assets/n8n/clic_down_lucas.gif)](https://n8n.ac)\n\nI really hope this tutorial helped you understand n8n Expressions better. Your feedback is incredibly valuable and helps me create better resources for the n8n community.\n\n### **Share Your Thoughts & Ideas**\n\nWhether you have a suggestion, found a typo, or just want to say thanks, I'd love to hear from you!\nHere's a simple n8n form built for this purpose:\n\n#### ➡️ **[Click here to give feedback](https://api.ia2s.app/form/templates/feedback?template=Expressions%20Tutorial)**\n\n### **Ready to Build Something Great?**\n\nIf you're looking to take your n8n skills or business automation to the next level, I can help.\n\n**🎓 n8n Coaching:** Want to become an n8n pro? I offer one-on-one coaching sessions to help you master workflows, tackle specific problems, and build with confidence.\n#### ➡️ **[Book a Coaching Session](https://api.ia2s.app/form/templates/coaching?template=Expressions%20Tutorial)**\n\n**💼 n8n Consulting:** Have a complex project, an integration challenge, or need a custom workflow built for your business? Let's work together to create a powerful automation solution.\n#### ➡️ **[Inquire About Consulting Services](https://api.ia2s.app/form/templates/consulting?template=Expressions%20Tutorial)**\n\n---\n\nHappy Automating!\nLucas Peyrin | [n8n Academy](https://n8n.ac)"
      },
      "typeVersion": 1
    },
    {
      "id": "efc93cff-1e16-46fc-a839-7cca5ccd27f8",
      "cid": "Ikx1Y2FzIFBleXJpbiI",
      "name": "Sticky Note15",
      "type": "n8n-nodes-base.stickyNote",
      "notes": "© 2025 Lucas Peyrin",
      "creator": "Lucas Peyrin",
      "position": [
        -896,
        304
      ],
      "parameters": {
        "color": 6,
        "width": 512,
        "height": 408,
        "content": "## [>> Go to Eval Workflow <<](https://n8n.io/workflows/6236)\n\nVerify your skills with a complete eval workflow to put your Expression Skills to the test.\n[![Test Skills](https://supastudio.ia2s.app/storage/v1/object/public/assets/n8n/test_your_skillls_button.gif)](https://n8n.io/workflows/6236)"
      },
      "typeVersion": 1
    }
  ],
  "connections": {
    "Source Data": {
      "main": [
        [
          {
            "node": "1. The Basics",
            "type": "main",
            "index": 0
          }
        ]
      ]
    },
    "1. The Basics": {
      "main": [
        [
          {
            "node": "2. The n8n Selectors",
            "type": "main",
            "index": 0
          }
        ]
      ]
    },
    "Start Tutorial": {
      "main": [
        [
          {
            "node": "Source Data",
            "type": "main",
            "index": 0
          }
        ]
      ]
    },
    "4. Going Deeper": {
      "main": [
        [
          {
            "node": "5. The Combo Move",
            "type": "main",
            "index": 0
          }
        ]
      ]
    },
    "Split Out Skills": {
      "main": [
        [
          {
            "node": "9. The \"All Items\" View",
            "type": "main",
            "index": 0
          }
        ]
      ]
    },
    "5. The Combo Move": {
      "main": [
        [
          {
            "node": "6. A Touch of Magic",
            "type": "main",
            "index": 0
          }
        ]
      ]
    },
    "6. A Touch of Magic": {
      "main": [
        [
          {
            "node": "7. Inspecting Objects",
            "type": "main",
            "index": 0
          }
        ]
      ]
    },
    "2. The n8n Selectors": {
      "main": [
        [
          {
            "node": "3. Working with Arrays",
            "type": "main",
            "index": 0
          }
        ]
      ]
    },
    "8. Utility Functions": {
      "main": [
        [
          {
            "node": "Split Out Skills",
            "type": "main",
            "index": 0
          }
        ]
      ]
    },
    "7. Inspecting Objects": {
      "main": [
        [
          {
            "node": "8. Utility Functions",
            "type": "main",
            "index": 0
          }
        ]
      ]
    },
    "3. Working with Arrays": {
      "main": [
        [
          {
            "node": "4. Going Deeper",
            "type": "main",
            "index": 0
          }
        ]
      ]
    },
    "9. The \"All Items\" View": {
      "main": [
        [
          {
            "node": "Final Exam",
            "type": "main",
            "index": 0
          }
        ]
      ]
    }
  },
  "id": 5271,
  "name": "🎓 Learn n8n Expressions with an Interactive Step-by-Step Tutorial for Beginners"
}
```
</details>