# Build Your First AI Agent
> **Category**: AI & Chatbots
> **Views**: 99,862
> **Created**: 7/22/2025
## Description
How it works

This template launches your very first AI Agent —an AI-powered chatbot that can do more than just talk— it can take action using tools.

Think of an AI Agent as a smart assistant, and the tools are the apps on its phone. By connecting it to other nodes, you give your agent the ability to interact with real-world data and services, like checking the weather, fetching news, or even sending emails on your behalf.

This workflow is designed to be the perfect starting point:
The Chat Interface:** A Chat Trigger node provides a simple, clean interface for you to talk to your agent.
The Brains:** The AI Agent node receives your messages, intelligently decides which tool to use (if any), and formulates a helpful response. Its personality and instructions are fully customizable in the "System Message".
The Language Model:* It uses *Google Gemini** to power its reasoning and conversation skills.
The Tools:** It comes pre-equipped with two tools to demonstrate its capabilities:
    Get Weather: Fetches real-time weather forecasts.
    Get News: Reads any RSS feed to get the latest headlines.
The Memory:** A Conversation Memory node allows the agent to remember the last few messages, enabling natural, follow-up conversations.

Set up steps

Setup time: ~2 minutes

You only need one thing to get started: a free Google AI API key.

Get Your Google AI API Key:
    Visit Google AI Studio at aistudio.google.com/app/apikey.
    Click "Create API key in new project" and copy the key that appears.

Add Your Credential in n8n:
    On the workflow canvas, go to the Connect your model (Google Gemini) node.
    Click the Credential dropdown and select + Create New Credential.
    Paste your API key into the API Key field and click Save.

Start Chatting!
    Go to the Example Chat node.
    Click the "Open Chat" button in its parameter panel.
    Try asking it one of the example questions, like: "What's the weather in Paris?" or "Get me the latest tech news."

That's it! You now have a fully functional AI Agent. Try adding more tools (like Gmail or Google Calendar) to make it even more powerful.
## Workflow Structure
# Build Your First AI Agent

## Basic Information

- Node count: 6
- Connection count: 5

## Key Nodes

### Triggers
- Example Chat (`@n8n/n8n-nodes-langchain.chatTrigger`)

### AI Nodes
- Your First AI Agent (`@n8n/n8n-nodes-langchain.agent`)
- Conversation Memory (`@n8n/n8n-nodes-langchain.memoryBufferWindow`)
- Connect Gemini (`@n8n/n8n-nodes-langchain.lmChatGoogleGemini`)

## All Nodes

| Node Name | Type | Category |
|-----------|------|----------|
| Get News | `n8n-nodes-base.rssFeedReadTool` | Other |
| Get Weather | `n8n-nodes-base.httpRequestTool` | Output |
| Your First AI Agent | `@n8n/n8n-nodes-langchain.agent` | AI |
| Example Chat | `@n8n/n8n-nodes-langchain.chatTrigger` | Trigger |
| Conversation Memory | `@n8n/n8n-nodes-langchain.memoryBufferWindow` | AI |
| Connect Gemini | `@n8n/n8n-nodes-langchain.lmChatGoogleGemini` | AI |

## Connections

```
Get News --[ai_tool]--> Your First AI Agent
Get Weather --[ai_tool]--> Your First AI Agent
Example Chat --[main]--> Your First AI Agent
Connect Gemini --[ai_languageModel]--> Your First AI Agent
Conversation Memory --[ai_memory]--> Your First AI Agent
```

## Workflow Summary

This workflow is triggered by Example Chat, uses Your First AI Agent, Conversation Memory, Connect Gemini for AI processing, finally outputs to Get Weather.
## Author Information
- **Name**: Lucas Peyrin
- **Username**: @lucaspeyrin
- Verified user
## Related Links
- [View this template on n8n.io](https://n8n.io/workflows/6270)
## Complete Workflow JSON
<details>
<summary>Click to expand Workflow JSON</summary>
```json
{
  "meta": {
    "instanceId": "e409ea34548a2afe2dffba31130cd1cf2e98ebe2afaeed2a63caf2a0582d1da0",
    "templateCredsSetupCompleted": true
  },
  "nodes": [
    {
      "id": "2c408b32-7862-4411-9ad1-b6e9ff4e41f7",
      "name": "Sticky Note2",
      "type": "n8n-nodes-base.stickyNote",
      "position": [
        592,
        -256
      ],
      "parameters": {
        "color": 7,
        "width": 512,
        "height": 352,
        "content": "## [Video Tutorial](https://youtu.be/laHIzhsz12E)\n@[youtube](laHIzhsz12E)"
      },
      "typeVersion": 1
    },
    {
      "id": "3808de8d-ef18-47f5-9621-b08ba961ae01",
      "cid": "Ikx1Y2FzIFBleXJpbiI",
      "name": "Introduction Note",
      "type": "n8n-nodes-base.stickyNote",
      "notes": "© 2025 Lucas Peyrin",
      "creator": "Lucas Peyrin",
      "position": [
        -752,
        -256
      ],
      "parameters": {
        "width": 392,
        "height": 460,
        "content": "## Try It Out!\n\n**Launch your first AI agent—a chatbot that uses tools to fetch live info, send emails, and automate tasks.**\n\n### To get started:\n1.  **Connect Gemini** (see red sticky note below)\n2.  Click the **🗨 Open chat** button and try asking:\n    *   “What’s the weather in Paris?”\n    *   “Get me the latest tech news.”\n    *   “Give me ideas for n8n AI agents.”\n\n### Questions or Feedback?\nFor feedback, coaching, buit-for-you workflows or any questions, use my unified AI-powered contact form.\n\n➡️ **[Get in Touch Here](https://api.ia2s.app/form/templates/academy)**\n\n*Happy Automating! —Lucas Peyrin*"
      },
      "typeVersion": 1
    },
    {
      "id": "2b55763c-0541-4133-aa79-87c3ce9f0564",
      "cid": "Ikx1Y2FzIFBleXJpbiI",
      "name": "Sticky Note12",
      "type": "n8n-nodes-base.stickyNote",
      "notes": "© 2025 Lucas Peyrin",
      "creator": "Lucas Peyrin",
      "position": [
        -272,
        -160
      ],
      "parameters": {
        "color": 7,
        "width": 300,
        "height": 252,
        "content": "💡 Later, activate this workflow and share the public chat URL to let others talk to your AI Agent!"
      },
      "typeVersion": 1
    },
    {
      "id": "f09c396a-dab8-41f8-a6e5-3dbd1dd70323",
      "cid": "Ikx1Y2FzIFBleXJpbiI",
      "name": "Sticky Note13",
      "type": "n8n-nodes-base.stickyNote",
      "notes": "© 2025 Lucas Peyrin",
      "creator": "Lucas Peyrin",
      "position": [
        112,
        -256
      ],
      "parameters": {
        "color": 7,
        "width": 396,
        "height": 348,
        "content": "Your AI agent can:\n1. **Receive** messages from the chat\n2. **Select** the right tools (e.g., weather, news, email)\n3. **Respond** with live, helpful answers\n\n\n**Open the AI agent node** and edit the **System Message** to adjust your agent’s thinking, behavior, and replies.\n\n\n\n\n\n\n\n\n\n\n"
      },
      "typeVersion": 1
    },
    {
      "id": "f7c57d33-2318-409d-9084-13990299db3d",
      "cid": "Ikx1Y2FzIFBleXJpbiI",
      "name": "Sticky Note15",
      "type": "n8n-nodes-base.stickyNote",
      "notes": "© 2025 Lucas Peyrin",
      "creator": "Lucas Peyrin",
      "position": [
        112,
        176
      ],
      "parameters": {
        "color": 7,
        "width": 308,
        "height": 260,
        "content": "\n\n\n\n\n\n\n\n\n\n\n\n\n\nThis node helps your agent remember the last few messages to stay on topic."
      },
      "typeVersion": 1
    },
    {
      "id": "07ed7ed3-91d0-432f-9327-d2a30601082c",
      "cid": "Ikx1Y2FzIFBleXJpbiI",
      "name": "Sticky Note16",
      "type": "n8n-nodes-base.stickyNote",
      "notes": "© 2025 Lucas Peyrin",
      "creator": "Lucas Peyrin",
      "position": [
        512,
        176
      ],
      "parameters": {
        "color": 7,
        "width": 372,
        "height": 324,
        "content": "\n\n\n\n\n\n\n\n\n\n\n\n\nThese tools let your agent access real-world data or take actions. Add more to expand its abilities!\n\nClick the ➕ under the agent’s Tool input to add:\n- Google Calendar (Get Upcoming Events)\n- Gmail (Send an Email) (Gmail)"
      },
      "typeVersion": 1
    },
    {
      "id": "24fc1fd5-ed10-43d9-9b35-8facb7f357d5",
      "cid": "Ikx1Y2FzIFBleXJpbiI",
      "name": "Get News",
      "type": "n8n-nodes-base.rssFeedReadTool",
      "notes": "© 2025 Lucas Peyrin",
      "creator": "Lucas Peyrin",
      "position": [
        656,
        224
      ],
      "parameters": {
        "url": "={{ /*n8n-auto-generated-fromAI-override*/ $fromAI('URL', `Use one of:\n- https://feeds.bbci.co.uk/news/world/rss.xml (BBC World – global headlines)\n- https://www.aljazeera.com/xml/rss/all.xml (Al Jazeera English – in‑depth global coverage)\n- http://rss.cnn.com/rss/edition_world.rss (CNN World – breaking news worldwide)\n- https://techcrunch.com/feed/ (TechCrunch – global tech & startup news)\n- http://news.ycombinator.com/rss (Hacker News – tech community headlines)\n- https://n8n.io/blog/rss (n8n Blog – updates & tutorials)\n- https://www.bonappetit.com/feed/recipes-rss-feed/rss (Bon Appétit – recent recipes list)\n- https://www.endsreport.com/rss/news-and-analysis (ENDS Report – environmental law & policy news)\n- https://medlineplus.gov/groupfeeds/new.xml (MedlinePlus – health topics & wellness updates)`, 'string') }}",
        "options": {},
        "toolDescription": "Gets the latest blog posts about any rss feed."
      },
      "typeVersion": 1.2
    },
    {
      "id": "ac7d0dd1-8885-41c1-abda-f3742c838992",
      "cid": "Ikx1Y2FzIFBleXJpbiI",
      "name": "Get Weather",
      "type": "n8n-nodes-base.httpRequestTool",
      "creator": "Lucas Peyrin",
      "position": [
        544,
        224
      ],
      "parameters": {
        "url": "https://api.open-meteo.com/v1/forecast",
        "options": {},
        "sendQuery": true,
        "queryParameters": {
          "parameters": [
            {
              "name": "latitude",
              "value": "={{ /*n8n-auto-generated-fromAI-override*/ $fromAI('parameters0_Value', `Latitude of the location, e.g. 45.75 for Lyon. Do not ask the user just infer it automatically.`, 'string') }}"
            },
            {
              "name": "longitude",
              "value": "={{ /*n8n-auto-generated-fromAI-override*/ $fromAI('parameters1_Value', `Longitude of the location, e.g. 4.85 for Lyon. Do not ask the user just infer it automatically.`, 'string') }}"
            },
            {
              "name": "current",
              "value": "={{ /*n8n-auto-generated-fromAI-override*/ $fromAI('parameters2_Value', `Comma-separated list of current weather variables (no whitespace).\n\nExample: temperature_2m,windspeed_10m,rain.\n\nOptions: temperature_2m,relative_humidity_2m,apparent_temperature,is_day,precipitation,rain,showers,snowfall,weathercode,cloudcover_total,pressure_msl,surface_pressure,windspeed_10m,winddirection_10m,windgusts_10m.`, 'string') }}"
            },
            {
              "name": "hourly",
              "value": "={{ /*n8n-auto-generated-fromAI-override*/ $fromAI('parameters3_Value', `Comma-separated list of hourly weather variables (no whitespace). Hourly is only useful to get one day's information. For weakly overview please use daily.\n\nExample: temperature_2m,precipitation.\n\nOptions: temperature_2m,relative_humidity_2m,dewpoint_2m,apparent_temperature,precipitation,rain,showers,snowfall,snow_depth,pressure_msl,surface_pressure,cloudcover_total,cloudcover_low,cloudcover_mid,cloudcover_high,windspeed_10m,winddirection_10m,windgusts_10m,visibility,is_day,sunshine_duration,soil_temperature,soil_moisture,PM10,PM2_5,carbon_monoxide,ozone,us_aqi,UV_index.`, 'string') }}"
            },
            {
              "name": "daily",
              "value": "={{ /*n8n-auto-generated-fromAI-override*/ $fromAI('parameters4_Value', `Comma-separated list of daily weather variables (no whitespace).\n\nExample: temperature_2m_max,precipitation_sum.\n\nOptions: weathercode,temperature_2m_max,temperature_2m_min,apparent_temperature_max,apparent_temperature_min,precipitation_sum,rain_sum,showers_sum,snowfall_sum,precipitation_hours,sunrise,sunset,daylight_duration,sunshine_duration,pressure_msl_max,pressure_msl_min,surface_pressure_max,surface_pressure_min,windgusts_10m_max,windspeed_10m_max,winddirection_10m_dominant,shortwave_radiation_sum.`, 'string') }}"
            },
            {
              "name": "start_date",
              "value": "={{ /*n8n-auto-generated-fromAI-override*/ $fromAI('parameters5_Value', `Start date in YYYY-MM-DD format. Example: 2025-07-15`, 'string') }}"
            },
            {
              "name": "end_date",
              "value": "={{ /*n8n-auto-generated-fromAI-override*/ $fromAI('parameters6_Value', `End date in YYYY-MM-DD format. Must be after start_date. Example: 2025-07-18`, 'string') }}"
            },
            {
              "name": "temperature_unit",
              "value": "={{ /*n8n-auto-generated-fromAI-override*/ $fromAI('parameters7_Value', `Unit for temperature. Options: celsius (default), fahrenheit.`, 'string') }}"
            }
          ]
        },
        "toolDescription": "Get weather forecast anywhere, anytime. You can make requests by assuming most information, the only thing you need is the location (use the city name to infer lat and long automatically) and time period (assume today if not specified)"
      },
      "notesInFlow": true,
      "typeVersion": 4.2
    },
    {
      "id": "332af12a-45ab-4e5d-8dab-da21ba2111f9",
      "cid": "Ikx1Y2FzIFBleXJpbiI",
      "name": "Your First AI Agent",
      "type": "@n8n/n8n-nodes-langchain.agent",
      "notes": "© 2025 Lucas Peyrin",
      "creator": "Lucas Peyrin",
      "position": [
        192,
        -64
      ],
      "parameters": {
        "options": {
          "systemMessage": "=<role>\nYou are the n8n Demo AI Agent, a friendly and helpful assistant designed to showcase the power of AI agents within the n8n automation platform. Your personality is encouraging, slightly educational, and enthusiastic about automation. Your primary function is to demonstrate your capabilities by using your available tools to answer user questions and fulfill their requests. You are conversational.\n</role>\n\n<instructions>\n<goal>\nYour primary goal is to act as a live demonstration of an AI Agent built with n8n. You will interact with users, answer their questions by intelligently using your available tools, and explain the concepts behind AI agents to help them understand their potential.\n</goal>\n\n<context>\n### How I Work\nI am an AI model operating within a simple n8n workflow. This workflow gives me two key things:\n1.  **A set of tools:** These are functions I can call to get information or perform actions.\n2.  **Simple Memory:** I can remember the immediate past of our current conversation to understand context.\n\n### My Purpose\nMy main purpose is to be a showcase. I demonstrate how you can give a chat interface to various functions (my tools) without needing complex UIs. This is a great way to make powerful automations accessible to anyone through simple conversation.\n\n### My Tools Instructions\nYou must choose one of your available tools if the user's request matches its capability. You cannot perform these actions yourself; you must call the tool.\n\n### About AI Agents in n8n\n- **Reliability:** While I can use one tool at a time effectively, more advanced agents can perform multi-step tasks. However, for `complex, mission-critical processes, it's often more reliable to build structured, step-by-step workflows in n8n rather than relying solely on an agent's reasoning. Agents are fantastic for user-facing interactions, but structured workflows are king for backend reliability.\n- **Best Practices:** A good practice is to keep an agent's toolset focused, typically under 10-15 tools, to ensure reliability and prevent confusion.\n\n### Current Date & Time\n{{ $now }}\n</context>\n\n<output_format>\n- Respond in a friendly, conversational, and helpful tone.\n- When a user's request requires a tool, first select the appropriate tool. Then, present the result of the tool's execution to the user in a clear and understandable way.\n- Be proactive. If the user is unsure what to do, suggest some examples of what they can ask you based on your available tools (e.g., Talk about your tools and what you know about yourself).\n</output_format>\n</instructions>"
        }
      },
      "typeVersion": 2.2
    },
    {
      "id": "95421925-c5ad-48bd-9638-c84ff5b5e3c6",
      "cid": "Ikx1Y2FzIFBleXJpbiI",
      "name": "Example Chat",
      "type": "@n8n/n8n-nodes-langchain.chatTrigger",
      "notes": "© 2025 Lucas Peyrin",
      "creator": "Lucas Peyrin",
      "position": [
        -176,
        -64
      ],
      "webhookId": "e5616171-e3b5-4c39-81d4-67409f9fa60a",
      "parameters": {
        "public": true,
        "options": {
          "title": "Your first AI Agent 🚀",
          "subtitle": "This is for demo purposes. Try me out !",
          "responseMode": "lastNode",
          "inputPlaceholder": "Type your message here...",
          "showWelcomeScreen": false
        },
        "initialMessages": "Hi there! 👋"
      },
      "typeVersion": 1.1
    },
    {
      "id": "56d2684a-7f83-4ffd-8501-3253d999b4c6",
      "cid": "Ikx1Y2FzIFBleXJpbiI",
      "name": "Conversation Memory",
      "type": "@n8n/n8n-nodes-langchain.memoryBufferWindow",
      "notes": "© 2025 Lucas Peyrin",
      "creator": "Lucas Peyrin",
      "position": [
        224,
        224
      ],
      "parameters": {
        "contextWindowLength": 30
      },
      "typeVersion": 1.3
    },
    {
      "id": "c218a5da-bec7-4034-8d2b-f4bca34e551e",
      "cid": "Ikx1Y2FzIFBleXJpbiI",
      "name": "Connect Gemini",
      "type": "@n8n/n8n-nodes-langchain.lmChatGoogleGemini",
      "notes": "© 2025 Lucas Peyrin",
      "creator": "Lucas Peyrin",
      "position": [
        -176,
        224
      ],
      "parameters": {
        "options": {
          "temperature": 0
        }
      },
      "typeVersion": 1
    },
    {
      "id": "199eb2cd-bc6b-4f61-bbf1-f196c7869b43",
      "cid": "Ikx1Y2FzIFBleXJpbiI",
      "name": "Sticky Note",
      "type": "n8n-nodes-base.stickyNote",
      "notes": "© 2025 Lucas Peyrin",
      "creator": "Lucas Peyrin",
      "position": [
        -272,
        176
      ],
      "parameters": {
        "color": 3,
        "width": 294,
        "height": 316,
        "content": "\n\n\n\n\n\n\n\n\n\n\n\n1. [In Google AI Studio](https://aistudio.google.com/app/apikey) click **“Create API key in new project”** and copy it.\n\n2. Open the ```Connect Gemini``` node:\n   * **Select Credential → Create New**\n   * Paste into **API Key** and **Save**\n"
      },
      "typeVersion": 1
    }
  ],
  "pinData": {},
  "connections": {
    "Get News": {
      "ai_tool": [
        [
          {
            "node": "Your First AI Agent",
            "type": "ai_tool",
            "index": 0
          }
        ]
      ]
    },
    "Get Weather": {
      "ai_tool": [
        [
          {
            "node": "Your First AI Agent",
            "type": "ai_tool",
            "index": 0
          }
        ]
      ]
    },
    "Example Chat": {
      "main": [
        [
          {
            "node": "Your First AI Agent",
            "type": "main",
            "index": 0
          }
        ]
      ]
    },
    "Connect Gemini": {
      "ai_languageModel": [
        [
          {
            "node": "Your First AI Agent",
            "type": "ai_languageModel",
            "index": 0
          }
        ]
      ]
    },
    "Conversation Memory": {
      "ai_memory": [
        [
          {
            "node": "Your First AI Agent",
            "type": "ai_memory",
            "index": 0
          }
        ]
      ]
    }
  },
  "id": 6270,
  "name": "Build Your First AI Agent"
}
```
</details>