# Automate Sales Cold Calling Pipeline with Apify, GPT-4o, and WhatsApp
> **Category**: AI & Chatbots
> **Views**: 21,581
> **Created**: 6/29/2025
## Description
This workflow contains community nodes that are only compatible with the self-hosted version of n8n. 

Cold Calling Automation - End-to-End Automated Cold Calling with Apify, RAG, and WhatsApp



The "Cold Calling Automation" workflow is designed to fully automate the end-to-end cold calling process by intelligently combining web scraping, AI-powered research, and WhatsApp messaging. Leveraging key technologies such as Apify for data scraping, RAG (Retrieval-Augmented Generation) for intelligent content creation, and WhatsApp integration for automated outreach, this workflow transforms raw prospect data into personalized, high-converting cold calling campaigns with minimal manual intervention.

💡 Why Use Cold Calling Automation?
Scale Your Outreach:** Automate hundreds of personalized cold calls without manual effort or hiring additional staff.  
Intelligent Personalization:** RAG technology creates highly relevant, personalized messages based on prospect research.  
Multi-Channel Approach:** Seamlessly integrate WhatsApp messaging with traditional cold calling methods.  
Real-Time Optimization:** Continuously improve message performance and conversion rates through AI analysis.  
Cost-Effective:** Reduce cold calling costs while dramatically increasing reach and response rates.

⚡ Who Is This For?
Sales Teams:** Looking to scale their cold calling efforts with intelligent automation and personalization.  
Lead Generation Agencies:** Needing to deliver high-volume, high-quality cold calling services to clients.  
Business Development Professionals:** Seeking to maximize outreach efficiency while maintaining personal touch.  
Small Business Owners:** Who want professional-grade cold calling capabilities without hiring expensive sales teams.  
Marketing Agencies:** Offering comprehensive lead generation and conversion services to clients.

❓ What Problem Does It Solve?
Traditional cold calling is time-consuming, expensive, and often ineffective due to lack of personalization and poor timing. Manual prospect research, script writing, and call execution create bottlenecks that limit outreach scale. Generic messages result in low response rates and damaged brand reputation. This workflow solves these problems by automating the entire cold calling pipeline - from prospect identification and research to personalized message creation and delivery - while maintaining high quality and relevance that converts prospects into qualified leads.

🔧 What This Workflow Does
⏱ Prospect Scraping: Uses Apify to automatically scrape and identify high-quality prospects based on your target criteria.  
🔍 Intelligent Research: Employs RAG technology to research each prospect and gather relevant business intelligence.  
✍️ Personalized Content: Automatically generates custom messages, scripts, and talking points for each prospect.  
📱 WhatsApp Integration: Delivers personalized messages through WhatsApp automation for maximum engagement.  
📊 Performance Tracking: Monitors response rates, engagement metrics, and conversion data for continuous optimization.  
🤖 AI-Powered Follow-up: Automatically handles initial responses and schedules appropriate follow-up actions.  
📈 Campaign Analytics: Provides detailed insights on campaign performance and ROI metrics.  
🔄 Continuous Learning: Improves message effectiveness and targeting based on campaign results.

This workflow also using community node: `@devlikeapro/n8n-nodes-waha`

🔐 Setup Instructions
Import the provided workflow JSON into your n8n instance (Cloud or self-hosted).  
Set up credentials:  
    Apify API credentials for prospect scraping  
    OpenAI API key for RAG and content generation  
    WhatsApp Business API credentials or WAHA integration  
    Database credentials for prospect and campaign tracking  
    Email credentials for notifications and reporting  
Customize parameters:  
    Target prospect criteria and scraping parameters  
    Message templates and personalization rules  
    Campaign timing and frequency settings  
    Response handling and follow-up logic  
    Performance tracking and reporting preferences  
Test the complete workflow with a small prospect list to verify scraping, personalization, and delivery.

🧩 Pre-Requirements
Active n8n instance (Cloud or Self-hosted)  
Apify account with appropriate scraping credits  
OpenAI API key with sufficient usage limits  
WhatsApp Business account or WAHA setup  
Database system for prospect and campaign management  
Basic understanding of your target audience and value proposition  

🛠️ Customize It Further
Integrate with CRM systems to sync prospects and track conversion through sales pipeline.  
Add voice calling capabilities using VoIP services for complete omnichannel outreach.  
Implement A/B testing for message templates and timing optimization.  
Connect with social media platforms for multi-channel prospecting and engagement.  
Add sentiment analysis to optimize message tone and approach for different prospect types.  
Integrate with calendar systems for automatic meeting scheduling from qualified responses.

🧠 Nodes Used
Apify nodes for prospect scraping and data collection  
OpenAI Chat Model and Embeddings for RAG implementation  
WhatsApp/WAHA nodes for message delivery and response handling  
Database nodes for prospect storage and campaign tracking  
HTTP Request nodes for API integrations and webhooks  
Code nodes for data processing and personalization logic  
Schedule Trigger for automated campaign execution  
Conditional nodes for response handling and follow-up logic  
Set nodes for parameter configuration and data transformation  
Split In Batches for efficient bulk processing

📊 Expected Results
50-80% increase** in cold calling efficiency and prospect reach  
25-40% higher** response rates compared to generic cold calling  
60-75% reduction** in manual research and message preparation time  
Real-time insights** into campaign performance and prospect engagement  
Scalable system** that grows with your business needs

📞 Support
Made by: khaisa Studio  
Tag: automation, cold calling, lead generation, apify, RAG, whatsapp, AI, sales automation, outreach  
Category: Sales Automation & Lead Generation  
Need a custom? contact me for more tailored templates
## Workflow Structure
# Automate Sales Cold Calling Pipeline with Apify, GPT-4o, and WhatsApp

## Basic Information

- Node count: 43
- Connection count: 38

## Key Nodes

### Triggers
- Google Drive Trigger (`n8n-nodes-base.googleDriveTrigger`)
- When clicking ‘Execute workflow’ (`n8n-nodes-base.manualTrigger`)
- Webhook (`n8n-nodes-base.webhook`)
- Google Sheets Trigger (`n8n-nodes-base.googleSheetsTrigger`)
- WAHA Trigger (`@devlikeapro/n8n-nodes-waha.wahaTrigger`)
- When chat message received (`@n8n/n8n-nodes-langchain.chatTrigger`)

### AI Nodes
- Supabase Vector Store (`@n8n/n8n-nodes-langchain.vectorStoreSupabase`)
- Embeddings OpenAI (`@n8n/n8n-nodes-langchain.embeddingsOpenAi`)
- Default Data Loader (`@n8n/n8n-nodes-langchain.documentDefaultDataLoader`)
- Recursive Character Text Splitter (`@n8n/n8n-nodes-langchain.textSplitterRecursiveCharacterTextSplitter`)
- AI Agent (`@n8n/n8n-nodes-langchain.agent`)
- OpenAI Chat Model (`@n8n/n8n-nodes-langchain.lmChatOpenAi`)
- Postgres Chat Memory (`@n8n/n8n-nodes-langchain.memoryPostgresChat`)
- Embeddings OpenAI1 (`@n8n/n8n-nodes-langchain.embeddingsOpenAi`)
- Supabase Vector Store2 (`@n8n/n8n-nodes-langchain.vectorStoreSupabase`)
- small3 (`@n8n/n8n-nodes-langchain.embeddingsOpenAi`)
- Default Data Loader2 (`@n8n/n8n-nodes-langchain.documentDefaultDataLoader`)
- Recursive Character Text Splitter1 (`@n8n/n8n-nodes-langchain.textSplitterRecursiveCharacterTextSplitter`)
- RAG (`@n8n/n8n-nodes-langchain.vectorStoreSupabase`)
- Leads (`@n8n/n8n-nodes-langchain.vectorStoreSupabase`)
- Embeddings OpenAI2 (`@n8n/n8n-nodes-langchain.embeddingsOpenAi`)
- AI Agent1 (`@n8n/n8n-nodes-langchain.agent`)
- Embeddings OpenAI3 (`@n8n/n8n-nodes-langchain.embeddingsOpenAi`)
- RAG1 (`@n8n/n8n-nodes-langchain.vectorStoreSupabase`)
- Leads1 (`@n8n/n8n-nodes-langchain.vectorStoreSupabase`)
- Embeddings OpenAI4 (`@n8n/n8n-nodes-langchain.embeddingsOpenAi`)
- Chat Memory (`@n8n/n8n-nodes-langchain.memoryPostgresChat`)
- Chat Model (`@n8n/n8n-nodes-langchain.lmChatOpenAi`)
- Reranker Cohere (`@n8n/n8n-nodes-langchain.rerankerCohere`)
- Reranker Cohere1 (`@n8n/n8n-nodes-langchain.rerankerCohere`)

## All Nodes

| Node Name | Type | Category |
|-----------|------|----------|
| Search File | `n8n-nodes-base.googleDrive` | Input |
| Get Data | `n8n-nodes-base.googleDrive` | Input |
| Supabase Vector Store | `@n8n/n8n-nodes-langchain.vectorStoreSupabase` | AI |
| Embeddings OpenAI | `@n8n/n8n-nodes-langchain.embeddingsOpenAi` | AI |
| Default Data Loader | `@n8n/n8n-nodes-langchain.documentDefaultDataLoader` | AI |
| Recursive Character Text Splitter | `@n8n/n8n-nodes-langchain.textSplitterRecursiveCharacterTextSplitter` | AI |
| Loop Over Items | `n8n-nodes-base.splitInBatches` | Other |
| AI Agent | `@n8n/n8n-nodes-langchain.agent` | AI |
| OpenAI Chat Model | `@n8n/n8n-nodes-langchain.lmChatOpenAi` | AI |
| Postgres Chat Memory | `@n8n/n8n-nodes-langchain.memoryPostgresChat` | AI |
| Embeddings OpenAI1 | `@n8n/n8n-nodes-langchain.embeddingsOpenAi` | AI |
| Google Drive Trigger | `n8n-nodes-base.googleDriveTrigger` | Trigger |
| When clicking ‘Execute workflow’ | `n8n-nodes-base.manualTrigger` | Trigger |
| Scrape Maps | `n8n-nodes-base.httpRequest` | Output |
| Clean Data | `n8n-nodes-base.code` | Transform |
| Update Data | `n8n-nodes-base.googleSheets` | Input |
| Webhook | `n8n-nodes-base.webhook` | Trigger |
| HTTP Request1 | `n8n-nodes-base.httpRequest` | Output |
| Get Result | `n8n-nodes-base.httpRequest` | Output |
| Append Leads | `n8n-nodes-base.googleSheets` | Input |
| Get Leads | `n8n-nodes-base.googleSheets` | Input |
| Supabase Vector Store2 | `@n8n/n8n-nodes-langchain.vectorStoreSupabase` | AI |
| small3 | `@n8n/n8n-nodes-langchain.embeddingsOpenAi` | AI |
| Default Data Loader2 | `@n8n/n8n-nodes-langchain.documentDefaultDataLoader` | AI |
| Recursive Character Text Splitter1 | `@n8n/n8n-nodes-langchain.textSplitterRecursiveCharacterTextSplitter` | AI |
| Google Sheets Trigger | `n8n-nodes-base.googleSheetsTrigger` | Trigger |
| Transform for Vector | `n8n-nodes-base.code` | Transform |
| Check Existing Data | `n8n-nodes-base.code` | Transform |
| RAG | `@n8n/n8n-nodes-langchain.vectorStoreSupabase` | AI |
| Leads | `@n8n/n8n-nodes-langchain.vectorStoreSupabase` | AI |
| Embeddings OpenAI2 | `@n8n/n8n-nodes-langchain.embeddingsOpenAi` | AI |
| WAHA Trigger | `@devlikeapro/n8n-nodes-waha.wahaTrigger` | Trigger |
| AI Agent1 | `@n8n/n8n-nodes-langchain.agent` | AI |
| Embeddings OpenAI3 | `@n8n/n8n-nodes-langchain.embeddingsOpenAi` | AI |
| RAG1 | `@n8n/n8n-nodes-langchain.vectorStoreSupabase` | AI |
| Leads1 | `@n8n/n8n-nodes-langchain.vectorStoreSupabase` | AI |
| Embeddings OpenAI4 | `@n8n/n8n-nodes-langchain.embeddingsOpenAi` | AI |
| When chat message received | `@n8n/n8n-nodes-langchain.chatTrigger` | Trigger |
| Chat Memory | `@n8n/n8n-nodes-langchain.memoryPostgresChat` | AI |
| Chat Model | `@n8n/n8n-nodes-langchain.lmChatOpenAi` | AI |
| Reranker Cohere | `@n8n/n8n-nodes-langchain.rerankerCohere` | AI |
| Reranker Cohere1 | `@n8n/n8n-nodes-langchain.rerankerCohere` | AI |
| Set Location | `n8n-nodes-base.set` | Transform |

## Connections

```
RAG --[ai_tool]--> AI Agent
RAG1 --[ai_tool]--> AI Agent1
Leads --[ai_tool]--> AI Agent
Leads1 --[ai_tool]--> AI Agent1
small3 --[ai_embedding]--> Supabase Vector Store2
Webhook --[main]--> Get Leads
Get Data --[main]--> Loop Over Items
Get Leads --[main]--> Clean Data
Chat Model --[ai_languageModel]--> AI Agent1
Clean Data --[main]--> Update Data
Get Result --[main]--> Append Leads
Chat Memory --[ai_memory]--> AI Agent1
Scrape Maps --[main]--> Get Result
Search File --[main]--> Get Data
Append Leads --[main]--> HTTP Request1
Set Location --[main]--> Scrape Maps
WAHA Trigger --[main]--> AI Agent
Loop Over Items --[main]--> Supabase Vector Store
Reranker Cohere --[ai_reranker]--> RAG1
Reranker Cohere1 --[ai_reranker]--> Leads1
Embeddings OpenAI --[ai_embedding]--> Supabase Vector Store
OpenAI Chat Model --[ai_languageModel]--> AI Agent
Embeddings OpenAI1 --[ai_embedding]--> RAG
Embeddings OpenAI2 --[ai_embedding]--> Leads
Embeddings OpenAI3 --[ai_embedding]--> RAG1
Embeddings OpenAI4 --[ai_embedding]--> Leads1
Check Existing Data --[main]--> Supabase Vector Store2
Default Data Loader --[ai_document]--> Supabase Vector Store
Default Data Loader2 --[ai_document]--> Supabase Vector Store2
Google Drive Trigger --[main]--> Search File
Postgres Chat Memory --[ai_memory]--> AI Agent
Transform for Vector --[main]--> Check Existing Data
Google Sheets Trigger --[main]--> Transform for Vector
Supabase Vector Store --[main]--> Loop Over Items
When chat message received --[main]--> AI Agent1
Recursive Character Text Splitter --[ai_textSplitter]--> Default Data Loader
Recursive Character Text Splitter1 --[ai_textSplitter]--> Default Data Loader2
When clicking ‘Execute workflow’ --[main]--> Set Location
```

## Workflow Summary

This workflow is triggered by Google Drive Trigger, When clicking ‘Execute workflow’, Webhook, Google Sheets Trigger, WAHA Trigger, When chat message received, uses Supabase Vector Store, Embeddings OpenAI, Default Data Loader, Recursive Character Text Splitter, AI Agent, OpenAI Chat Model, Postgres Chat Memory, Embeddings OpenAI1, Supabase Vector Store2, small3, Default Data Loader2, Recursive Character Text Splitter1, RAG, Leads, Embeddings OpenAI2, AI Agent1, Embeddings OpenAI3, RAG1, Leads1, Embeddings OpenAI4, Chat Memory, Chat Model, Reranker Cohere, Reranker Cohere1 for AI processing, goes through 4 transformation step(s), finally outputs to Scrape Maps, HTTP Request1, Get Result.
## Author Information
- **Name**: Khairul Muhtadin
- **Username**: @khmuhtadin
- Verified user
## Related Links
- [View this template on n8n.io](https://n8n.io/workflows/5449)
## Complete Workflow JSON
<details>
<summary>Click to expand Workflow JSON</summary>
```json
{
  "id": 5449,
  "meta": {
    "instanceId": "c2650793f644091dc80fb900fe63448ad1f4b774008de9608064d67294f8307c",
    "templateCredsSetupCompleted": true
  },
  "name": "Automate Sales Cold Calling Pipeline with Apify, GPT-4o, and WhatsApp",
  "tags": [],
  "nodes": [
    {
      "id": "f0678325-baee-4210-886b-72d4e4fcc4ce",
      "name": "Search File",
      "type": "n8n-nodes-base.googleDrive",
      "position": [
        3680,
        580
      ],
      "parameters": {
        "filter": {
          "folderId": {
            "__rl": true,
            "mode": "list",
            "value": "1dh1Rr2yrhSdoSYpiR8s1yXiSWLYxpoLJ",
            "cachedResultUrl": "https://drive.google.com/drive/folders/1dh1Rr2yrhSdoSYpiR8s1yXiSWLYxpoLJ",
            "cachedResultName": "ReCharge"
          }
        },
        "options": {},
        "resource": "fileFolder",
        "returnAll": true
      },
      "credentials": {
        "googleDriveOAuth2Api": {
          "id": "nTWGelaHlbvHrG66",
          "name": "Khaisa Studio"
        }
      },
      "typeVersion": 3
    },
    {
      "id": "52a98bc4-4364-49cd-b7dc-5ea77024473e",
      "name": "Get Data",
      "type": "n8n-nodes-base.googleDrive",
      "position": [
        3840,
        580
      ],
      "parameters": {
        "fileId": {
          "__rl": true,
          "mode": "id",
          "value": "={{ $json.id }}"
        },
        "options": {},
        "operation": "download"
      },
      "credentials": {
        "googleDriveOAuth2Api": {
          "id": "nTWGelaHlbvHrG66",
          "name": "Khaisa Studio"
        }
      },
      "typeVersion": 3
    },
    {
      "id": "13e41f0e-c890-4e8c-8fc0-76615187c1db",
      "name": "Supabase Vector Store",
      "type": "@n8n/n8n-nodes-langchain.vectorStoreSupabase",
      "position": [
        4080,
        380
      ],
      "parameters": {
        "mode": "insert",
        "options": {},
        "tableName": {
          "__rl": true,
          "mode": "list",
          "value": "documents",
          "cachedResultName": "documents"
        }
      },
      "credentials": {
        "supabaseApi": {
          "id": "rb73xq0erYUAZCau",
          "name": "REcharge"
        }
      },
      "typeVersion": 1.1
    },
    {
      "id": "739dd64e-9493-41de-b5aa-f0a376e8ce85",
      "name": "Embeddings OpenAI",
      "type": "@n8n/n8n-nodes-langchain.embeddingsOpenAi",
      "position": [
        4060,
        560
      ],
      "parameters": {
        "options": {}
      },
      "credentials": {
        "openAiApi": {
          "id": "IWdqsaVAq1AL1S28",
          "name": "n8n - Money manager Khairul"
        }
      },
      "typeVersion": 1.2
    },
    {
      "id": "6674cbfc-c0e0-48e1-b044-d7ee693dfc83",
      "name": "Default Data Loader",
      "type": "@n8n/n8n-nodes-langchain.documentDefaultDataLoader",
      "position": [
        4200,
        580
      ],
      "parameters": {
        "options": {},
        "dataType": "binary"
      },
      "typeVersion": 1
    },
    {
      "id": "b3c042bb-4c0b-4dd3-ac7e-be7a99d792df",
      "name": "Recursive Character Text Splitter",
      "type": "@n8n/n8n-nodes-langchain.textSplitterRecursiveCharacterTextSplitter",
      "position": [
        4240,
        720
      ],
      "parameters": {
        "options": {}
      },
      "typeVersion": 1
    },
    {
      "id": "13cff178-5db2-478e-97de-dee175b62a8f",
      "name": "Loop Over Items",
      "type": "n8n-nodes-base.splitInBatches",
      "position": [
        3860,
        380
      ],
      "parameters": {
        "options": {}
      },
      "typeVersion": 3
    },
    {
      "id": "a077fb5d-f2c5-40c4-9dd5-6abc28a21311",
      "name": "AI Agent",
      "type": "@n8n/n8n-nodes-langchain.agent",
      "position": [
        2380,
        740
      ],
      "parameters": {
        "text": "={{ $json.payload._data.key.id }}",
        "options": {
          "systemMessage": "=You are a business intelligence assistant for ReCharge with access to:\n\n1. **company knowledge based** - General business documents and guides\n2. **Restaurant Leads Database** - Potential restaurant clients with ratings, contact info, and business details\n\nYou can help with:\n- Finding high-potential restaurant leads by location, rating, or category\n- Analyzing restaurant market opportunities  \n- Providing restaurant recommendations and insights\n- Preparing cold outreach strategies with personalized data\n- Business intelligence from collected restaurant data\n\nAlways use both knowledge sources to provide comprehensive answers."
        },
        "promptType": "define"
      },
      "typeVersion": 2
    },
    {
      "id": "ef8f5cec-f189-4d46-b5b3-7a07b201f942",
      "name": "OpenAI Chat Model",
      "type": "@n8n/n8n-nodes-langchain.lmChatOpenAi",
      "position": [
        2320,
        900
      ],
      "parameters": {
        "model": {
          "__rl": true,
          "mode": "list",
          "value": "gpt-4o-mini"
        },
        "options": {}
      },
      "credentials": {
        "openAiApi": {
          "id": "IWdqsaVAq1AL1S28",
          "name": "n8n - Money manager Khairul"
        }
      },
      "typeVersion": 1.2
    },
    {
      "id": "c054fd37-688b-40ef-86c7-fb7ada0b13ba",
      "name": "Postgres Chat Memory",
      "type": "@n8n/n8n-nodes-langchain.memoryPostgresChat",
      "position": [
        2460,
        900
      ],
      "parameters": {
        "sessionKey": "={{ $('WAHA Trigger').item.json.payload._data.key.remoteJid }}",
        "sessionIdType": "customKey",
        "contextWindowLength": 20
      },
      "credentials": {
        "postgres": {
          "id": "8PMGgjtS4muxnKxT",
          "name": "ReCharge Database"
        }
      },
      "typeVersion": 1.3
    },
    {
      "id": "482e862f-6592-4d02-9bd1-6b50d1e87e5b",
      "name": "Embeddings OpenAI1",
      "type": "@n8n/n8n-nodes-langchain.embeddingsOpenAi",
      "position": [
        2600,
        1040
      ],
      "parameters": {
        "options": {}
      },
      "credentials": {
        "openAiApi": {
          "id": "IWdqsaVAq1AL1S28",
          "name": "n8n - Money manager Khairul"
        }
      },
      "typeVersion": 1.2
    },
    {
      "id": "3b6a1f51-882b-4f0c-9e39-2676c08f1e71",
      "name": "Google Drive Trigger",
      "type": "n8n-nodes-base.googleDriveTrigger",
      "position": [
        3500,
        580
      ],
      "parameters": {
        "event": "fileUpdated",
        "options": {
          "fileType": "all"
        },
        "pollTimes": {
          "item": [
            {
              "hour": 0
            }
          ]
        },
        "triggerOn": "specificFolder",
        "folderToWatch": {
          "__rl": true,
          "mode": "list",
          "value": "1dh1Rr2yrhSdoSYpiR8s1yXiSWLYxpoLJ",
          "cachedResultUrl": "https://drive.google.com/drive/folders/1dh1Rr2yrhSdoSYpiR8s1yXiSWLYxpoLJ",
          "cachedResultName": "ReCharge"
        }
      },
      "credentials": {
        "googleDriveOAuth2Api": {
          "id": "nTWGelaHlbvHrG66",
          "name": "Khaisa Studio"
        }
      },
      "typeVersion": 1
    },
    {
      "id": "91703e9f-78c7-4db3-a58f-b9736379d6f5",
      "name": "Sticky Note",
      "type": "n8n-nodes-base.stickyNote",
      "position": [
        3420,
        260
      ],
      "parameters": {
        "color": 5,
        "width": 1100,
        "height": 620,
        "content": "# Company Knowledge Base\n"
      },
      "typeVersion": 1
    },
    {
      "id": "0ea74b68-0ade-4b9a-9371-38184aac722f",
      "name": "When clicking ‘Execute workflow’",
      "type": "n8n-nodes-base.manualTrigger",
      "position": [
        2080,
        180
      ],
      "parameters": {},
      "typeVersion": 1
    },
    {
      "id": "9150f04a-1201-41e8-902d-dcf18c7a6bb2",
      "name": "Scrape Maps",
      "type": "n8n-nodes-base.httpRequest",
      "position": [
        2520,
        180
      ],
      "parameters": {
        "url": "<your apify url>",
        "method": "POST",
        "options": {},
        "jsonBody": "={\n    \"includeWebResults\": false,\n    \"language\": \"id\",\n    \"locationQuery\": \"{{ $json.lokasi }}\",\n    \"maxCrawledPlacesPerSearch\": 500,\n    \"maxImages\": 0,\n    \"maximumLeadsEnrichmentRecords\": 0,\n    \"scrapeContacts\": false,\n    \"scrapeDirectories\": false,\n    \"scrapeImageAuthors\": false,\n    \"scrapePlaceDetailPage\": false,\n    \"scrapeReviewsPersonalData\": true,\n    \"scrapeTableReservationProvider\": false,\n    \"searchStringsArray\": [\n        \"Restoran\"\n    ],\n    \"skipClosedPlaces\": false\n}",
        "sendBody": true,
        "specifyBody": "json"
      },
      "typeVersion": 4.2
    },
    {
      "id": "ee02f5bb-be98-4344-b9d3-1637e923d7e2",
      "name": "Clean Data",
      "type": "n8n-nodes-base.code",
      "position": [
        2520,
        380
      ],
      "parameters": {
        "jsCode": "// Bersihkan dan format data dari spreadsheet\nconst cleanData = $input.all().map(item => {\n  const data = item.json;\n  \n  // Parse JSON strings jadi array yang mudah dibaca\n  function parseJsonField(field) {\n    try {\n      if (!field || field === 'not found') return [];\n      const parsed = JSON.parse(field);\n      if (Array.isArray(parsed)) {\n        return parsed.map(item => {\n          if (typeof item === 'object') {\n            return Object.keys(item).filter(key => item[key] === true);\n          }\n          return item;\n        }).flat();\n      }\n      return [];\n    } catch {\n      return [];\n    }\n  }\n  \n  // Parse opening hours jadi format mudah dibaca\n  function parseOpeningHours(hoursString) {\n    try {\n      if (!hoursString) return 'Jam buka tidak tersedia';\n      const hours = JSON.parse(hoursString);\n      return hours.map(h => `${h.day}: ${h.hours}`).join(', ');\n    } catch {\n      return 'Jam buka tidak tersedia';\n    }\n  }\n  \n  // Ekstrak data bersih\n  const keunggulan = parseJsonField(data.Keunggulan);\n  const fasilitas = parseJsonField(data.Fasilitas);\n  const pembayaran = parseJsonField(data.Pembayaran);\n  const allCategories = parseJsonField(data['All Categories']);\n  const openingHours = parseOpeningHours(data['Opening Hours']);\n  \n  // Buat deskripsi lengkap untuk AI\n  const businessDescription = `\n${data.Title} adalah ${data.Category} yang berlokasi di ${data.Neighborhood}. \nRating: ${data.Rating}/5 dengan ${data.Reviews} review. \nHarga: ${data.Price || 'Tidak diketahui'}.\n${data.Description || ''}\n\nKeunggulan: ${keunggulan.join(', ') || 'Tidak ada info keunggulan'}\nFasilitas: ${fasilitas.join(', ') || 'Tidak ada info fasilitas'}  \nMetode Pembayaran: ${pembayaran.join(', ') || 'Tidak ada info pembayaran'}\nKategori: ${allCategories.join(', ') || data.Category}\nJam Buka: ${openingHours}\n\nKontak: ${data.Phone || 'Tidak ada nomor telepon'}\nWebsite: ${data.Website !== 'not found' ? data.Website : 'Tidak ada website'}\nAlamat Lengkap: ${data.Address}\n`.trim();\n\n  // Hitung lead score\n  let leadScore = 0;\n  if (data.Rating >= 4.5) leadScore += 30;\n  if (data.Rating >= 4.0) leadScore += 20;\n  if (data.Reviews >= 1000) leadScore += 25;\n  if (data.Reviews >= 100) leadScore += 15;\n  if (data.Phone) leadScore += 20;\n  if (data.Website && data.Website !== 'not found') leadScore += 20;\n  if (keunggulan.length > 0) leadScore += 10;\n\n  return {\n    // Data utama\n    restaurant_name: data.Title,\n    category: data.Category,\n    description: data.Description || '',\n    location: data.Neighborhood,\n    full_address: data.Address,\n    phone: data.Phone,\n    website: data.Website !== 'not found' ? data.Website : '',\n    rating: data.Rating,\n    total_reviews: data.Reviews,\n    price_range: data.Price || 'Tidak diketahui',\n    \n    // Data terformat\n    keunggulan_list: keunggulan.join(', '),\n    fasilitas_list: fasilitas.join(', '),\n    pembayaran_list: pembayaran.join(', '),\n    kategori_lengkap: allCategories.join(', '),\n    jam_operasional: openingHours,\n    \n    // Untuk AI analysis\n    business_summary: businessDescription,\n    lead_score: leadScore,\n    lead_quality: leadScore >= 70 ? 'High' : leadScore >= 40 ? 'Medium' : 'Low',\n    \n    // Metadata\n    scraped_date: new Date().toLocaleString('id-ID'),\n    data_source: 'Google Maps via Apify'\n  };\n});\n\nreturn cleanData;"
      },
      "typeVersion": 2
    },
    {
      "id": "93664ba7-c18c-4064-b984-f592791cb731",
      "name": "Update Data",
      "type": "n8n-nodes-base.googleSheets",
      "position": [
        2740,
        380
      ],
      "parameters": {
        "columns": {
          "value": {
            "Phone": "={{ $json.phone }}",
            "Price": "={{ $json.price_range }}",
            "Title": "={{ $json.restaurant_name }}",
            "Rating": "={{ $json.rating }}",
            "Address": "={{ $json.full_address }}",
            "Reviews": "={{ $json.total_reviews }}",
            "Website": "={{ $json.website }}",
            "Category": "={{ $json.category }}",
            "Fasilitas": "={{ $json.fasilitas_list }}",
            "Keunggulan": "={{ $json.keunggulan_list }}",
            "Lead Score": "={{ $json.lead_score }}",
            "Pembayaran": "={{ $json.pembayaran_list }}",
            "row_number": "={{ $('Get Leads').item.json.row_number }}",
            "Description": "={{ $json.description }}",
            "Lead Quality": "={{ $json.lead_quality }}",
            "Neighborhood": "={{ $json.location }}",
            "Opening Hours": "={{ $json.jam_operasional }}",
            "All Categories": "={{ $json.kategori_lengkap }}"
          },
          "schema": [
            {
              "id": "Title",
              "type": "string",
              "display": true,
              "removed": false,
              "required": false,
              "displayName": "Title",
              "defaultMatch": false,
              "canBeUsedToMatch": true
            },
            {
              "id": "Description",
              "type": "string",
              "display": true,
              "required": false,
              "displayName": "Description",
              "defaultMatch": false,
              "canBeUsedToMatch": true
            },
            {
              "id": "Category",
              "type": "string",
              "display": true,
              "required": false,
              "displayName": "Category",
              "defaultMatch": false,
              "canBeUsedToMatch": true
            },
            {
              "id": "Address",
              "type": "string",
              "display": true,
              "required": false,
              "displayName": "Address",
              "defaultMatch": false,
              "canBeUsedToMatch": true
            },
            {
              "id": "Phone",
              "type": "string",
              "display": true,
              "required": false,
              "displayName": "Phone",
              "defaultMatch": false,
              "canBeUsedToMatch": true
            },
            {
              "id": "Rating",
              "type": "string",
              "display": true,
              "required": false,
              "displayName": "Rating",
              "defaultMatch": false,
              "canBeUsedToMatch": true
            },
            {
              "id": "Reviews",
              "type": "string",
              "display": true,
              "required": false,
              "displayName": "Reviews",
              "defaultMatch": false,
              "canBeUsedToMatch": true
            },
            {
              "id": "Price",
              "type": "string",
              "display": true,
              "required": false,
              "displayName": "Price",
              "defaultMatch": false,
              "canBeUsedToMatch": true
            },
            {
              "id": "Website",
              "type": "string",
              "display": true,
              "required": false,
              "displayName": "Website",
              "defaultMatch": false,
              "canBeUsedToMatch": true
            },
            {
              "id": "Neighborhood",
              "type": "string",
              "display": true,
              "required": false,
              "displayName": "Neighborhood",
              "defaultMatch": false,
              "canBeUsedToMatch": true
            },
            {
              "id": "Opening Hours",
              "type": "string",
              "display": true,
              "required": false,
              "displayName": "Opening Hours",
              "defaultMatch": false,
              "canBeUsedToMatch": true
            },
            {
              "id": "All Categories",
              "type": "string",
              "display": true,
              "required": false,
              "displayName": "All Categories",
              "defaultMatch": false,
              "canBeUsedToMatch": true
            },
            {
              "id": "Keunggulan",
              "type": "string",
              "display": true,
              "required": false,
              "displayName": "Keunggulan",
              "defaultMatch": false,
              "canBeUsedToMatch": true
            },
            {
              "id": "Fasilitas",
              "type": "string",
              "display": true,
              "required": false,
              "displayName": "Fasilitas",
              "defaultMatch": false,
              "canBeUsedToMatch": true
            },
            {
              "id": "Pembayaran",
              "type": "string",
              "display": true,
              "required": false,
              "displayName": "Pembayaran",
              "defaultMatch": false,
              "canBeUsedToMatch": true
            },
            {
              "id": "Lead Score",
              "type": "string",
              "display": true,
              "removed": false,
              "required": false,
              "displayName": "Lead Score",
              "defaultMatch": false,
              "canBeUsedToMatch": true
            },
            {
              "id": "Lead Quality",
              "type": "string",
              "display": true,
              "removed": false,
              "required": false,
              "displayName": "Lead Quality",
              "defaultMatch": false,
              "canBeUsedToMatch": true
            },
            {
              "id": "row_number",
              "type": "string",
              "display": true,
              "removed": false,
              "readOnly": true,
              "required": false,
              "displayName": "row_number",
              "defaultMatch": false,
              "canBeUsedToMatch": true
            }
          ],
          "mappingMode": "defineBelow",
          "matchingColumns": [
            "row_number"
          ],
          "attemptToConvertTypes": false,
          "convertFieldsToString": false
        },
        "options": {},
        "operation": "update",
        "sheetName": {
          "__rl": true,
          "mode": "list",
          "value": "gid=0",
          "cachedResultUrl": "https://docs.google.com/spreadsheets/d/1DKXYqpb0EWNYsbq2x8h5xqUWXy772toNDVrl8d-8nfA/edit#gid=0",
          "cachedResultName": "Restaurant"
        },
        "documentId": {
          "__rl": true,
          "mode": "url",
          "value": "https://docs.google.com/spreadsheets/d/1DKXYqpb0EWNYsbq2x8h5xqUWXy772toNDVrl8d-8nfA/edit?usp=sharing"
        },
        "authentication": "serviceAccount"
      },
      "credentials": {
        "googleApi": {
          "id": "Os8sgTGkRS1YybbJ",
          "name": "Sheet & Drive"
        }
      },
      "typeVersion": 4.6
    },
    {
      "id": "51681e42-74ca-4fe8-9254-40f150c0a2aa",
      "name": "Webhook",
      "type": "n8n-nodes-base.webhook",
      "disabled": true,
      "position": [
        2080,
        380
      ],
      "webhookId": "4ef17aa0-fc90-4b34-a6e2-e8a2ede9c334",
      "parameters": {
        "path": "<your webhook>",
        "options": {}
      },
      "typeVersion": 2
    },
    {
      "id": "e0fea0f5-7281-439f-bf90-841a80646590",
      "name": "HTTP Request1",
      "type": "n8n-nodes-base.httpRequest",
      "disabled": true,
      "position": [
        3180,
        180
      ],
      "parameters": {
        "url": "<your webhook>",
        "options": {}
      },
      "typeVersion": 4.2
    },
    {
      "id": "92aa2a7f-c626-4a60-99e4-b5712ba9a1c1",
      "name": "Get Result",
      "type": "n8n-nodes-base.httpRequest",
      "position": [
        2740,
        180
      ],
      "parameters": {
        "url": "<your apify get>",
        "options": {}
      },
      "typeVersion": 4.2
    },
    {
      "id": "412a7be8-66ec-484c-b539-583dbe531f73",
      "name": "Append Leads",
      "type": "n8n-nodes-base.googleSheets",
      "position": [
        2960,
        180
      ],
      "parameters": {
        "columns": {
          "value": {
            "Phone": "={{ $json.phone ? $json.phone.replace(/[-\\s]/g, '') : '' }}",
            "Price": "={{ $json.price }}",
            "Title": "={{ $json.title }}",
            "Rating": "={{ $json.totalScore }}",
            "Address": "={{ $json.address }}",
            "Reviews": "={{ $json.reviewsCount }}",
            "Website": "={{ $json.website || \"not found\" }}",
            "Category": "={{ $json.categoryName }}",
            "Fasilitas": "={{ $json.additionalInfo.Fasilitas }}",
            "Keunggulan": "={{ $json.additionalInfo.Keunggulan }}",
            "Pembayaran": "={{ $json.additionalInfo.Pembayaran }}",
            "Description": "={{ $json.description }}",
            "Neighborhood": "={{ $json.neighborhood }}",
            "Opening Hours": "={{ $json.openingHours }}",
            "All Categories": "={{ $json.categories }}"
          },
          "schema": [
            {
              "id": "Title",
              "type": "string",
              "display": true,
              "required": false,
              "displayName": "Title",
              "defaultMatch": false,
              "canBeUsedToMatch": true
            },
            {
              "id": "Description",
              "type": "string",
              "display": true,
              "removed": false,
              "required": false,
              "displayName": "Description",
              "defaultMatch": false,
              "canBeUsedToMatch": true
            },
            {
              "id": "Category",
              "type": "string",
              "display": true,
              "required": false,
              "displayName": "Category",
              "defaultMatch": false,
              "canBeUsedToMatch": true
            },
            {
              "id": "Address",
              "type": "string",
              "display": true,
              "required": false,
              "displayName": "Address",
              "defaultMatch": false,
              "canBeUsedToMatch": true
            },
            {
              "id": "Phone",
              "type": "string",
              "display": true,
              "required": false,
              "displayName": "Phone",
              "defaultMatch": false,
              "canBeUsedToMatch": true
            },
            {
              "id": "Rating",
              "type": "string",
              "display": true,
              "required": false,
              "displayName": "Rating",
              "defaultMatch": false,
              "canBeUsedToMatch": true
            },
            {
              "id": "Reviews",
              "type": "string",
              "display": true,
              "required": false,
              "displayName": "Reviews",
              "defaultMatch": false,
              "canBeUsedToMatch": true
            },
            {
              "id": "Price",
              "type": "string",
              "display": true,
              "required": false,
              "displayName": "Price",
              "defaultMatch": false,
              "canBeUsedToMatch": true
            },
            {
              "id": "Website",
              "type": "string",
              "display": true,
              "required": false,
              "displayName": "Website",
              "defaultMatch": false,
              "canBeUsedToMatch": true
            },
            {
              "id": "Neighborhood",
              "type": "string",
              "display": true,
              "required": false,
              "displayName": "Neighborhood",
              "defaultMatch": false,
              "canBeUsedToMatch": true
            },
            {
              "id": "Opening Hours",
              "type": "string",
              "display": true,
              "required": false,
              "displayName": "Opening Hours",
              "defaultMatch": false,
              "canBeUsedToMatch": true
            },
            {
              "id": "All Categories",
              "type": "string",
              "display": true,
              "required": false,
              "displayName": "All Categories",
              "defaultMatch": false,
              "canBeUsedToMatch": true
            },
            {
              "id": "Keunggulan",
              "type": "string",
              "display": true,
              "removed": false,
              "required": false,
              "displayName": "Keunggulan",
              "defaultMatch": false,
              "canBeUsedToMatch": true
            },
            {
              "id": "Fasilitas",
              "type": "string",
              "display": true,
              "removed": false,
              "required": false,
              "displayName": "Fasilitas",
              "defaultMatch": false,
              "canBeUsedToMatch": true
            },
            {
              "id": "Pembayaran",
              "type": "string",
              "display": true,
              "removed": false,
              "required": false,
              "displayName": "Pembayaran",
              "defaultMatch": false,
              "canBeUsedToMatch": true
            }
          ],
          "mappingMode": "defineBelow",
          "matchingColumns": [],
          "attemptToConvertTypes": false,
          "convertFieldsToString": false
        },
        "options": {},
        "operation": "append",
        "sheetName": {
          "__rl": true,
          "mode": "list",
          "value": "gid=0",
          "cachedResultUrl": "https://docs.google.com/spreadsheets/d/1DKXYqpb0EWNYsbq2x8h5xqUWXy772toNDVrl8d-8nfA/edit#gid=0",
          "cachedResultName": "Restaurant"
        },
        "documentId": {
          "__rl": true,
          "mode": "url",
          "value": "https://docs.google.com/spreadsheets/d/1DKXYqpb0EWNYsbq2x8h5xqUWXy772toNDVrl8d-8nfA/edit?usp=sharing"
        },
        "authentication": "serviceAccount"
      },
      "credentials": {
        "googleApi": {
          "id": "Os8sgTGkRS1YybbJ",
          "name": "Sheet & Drive"
        }
      },
      "typeVersion": 4.6
    },
    {
      "id": "93eefe61-c614-4f52-8d3e-2bcc268628bc",
      "name": "Get Leads",
      "type": "n8n-nodes-base.googleSheets",
      "position": [
        2300,
        380
      ],
      "parameters": {
        "sheetName": {
          "__rl": true,
          "mode": "list",
          "value": "",
          "cachedResultUrl": "",
          "cachedResultName": ""
        },
        "documentId": {
          "__rl": true,
          "mode": "list",
          "value": ""
        },
        "authentication": "serviceAccount"
      },
      "credentials": {
        "googleApi": {
          "id": "Os8sgTGkRS1YybbJ",
          "name": "Sheet & Drive"
        }
      },
      "typeVersion": 4.6
    },
    {
      "id": "d666e66e-a749-4484-8564-a136e54a4dd2",
      "name": "Sticky Note1",
      "type": "n8n-nodes-base.stickyNote",
      "position": [
        2020,
        80
      ],
      "parameters": {
        "color": 7,
        "width": 1360,
        "height": 520,
        "content": "# Scrapping and data Cleaning\n"
      },
      "typeVersion": 1
    },
    {
      "id": "3b072239-fc03-4208-b2c6-2a8dc9dd4bed",
      "name": "Supabase Vector Store2",
      "type": "@n8n/n8n-nodes-langchain.vectorStoreSupabase",
      "position": [
        4080,
        1060
      ],
      "parameters": {
        "mode": "insert",
        "options": {},
        "tableName": {
          "__rl": true,
          "mode": "list",
          "value": "restaurant_leads",
          "cachedResultName": "restaurant_leads"
        }
      },
      "credentials": {
        "supabaseApi": {
          "id": "rb73xq0erYUAZCau",
          "name": "REcharge"
        }
      },
      "typeVersion": 1.3
    },
    {
      "id": "1237145e-e64e-4f52-880c-07a7acd58bb3",
      "name": "small3",
      "type": "@n8n/n8n-nodes-langchain.embeddingsOpenAi",
      "position": [
        4060,
        1280
      ],
      "parameters": {
        "options": {}
      },
      "credentials": {
        "openAiApi": {
          "id": "IWdqsaVAq1AL1S28",
          "name": "n8n - Money manager Khairul"
        }
      },
      "typeVersion": 1.2
    },
    {
      "id": "7beea738-09bb-44c2-80eb-405ea9bca15b",
      "name": "Default Data Loader2",
      "type": "@n8n/n8n-nodes-langchain.documentDefaultDataLoader",
      "position": [
        4200,
        1220
      ],
      "parameters": {
        "options": {}
      },
      "typeVersion": 1
    },
    {
      "id": "88ae6f60-796c-4507-8c5e-c71ed7232533",
      "name": "Recursive Character Text Splitter1",
      "type": "@n8n/n8n-nodes-langchain.textSplitterRecursiveCharacterTextSplitter",
      "position": [
        4200,
        1360
      ],
      "parameters": {
        "options": {},
        "chunkOverlap": 200
      },
      "typeVersion": 1
    },
    {
      "id": "ab1ca886-dad6-4cc5-83a7-da5d2c6f0fd4",
      "name": "Google Sheets Trigger",
      "type": "n8n-nodes-base.googleSheetsTrigger",
      "position": [
        3480,
        1060
      ],
      "parameters": {
        "options": {},
        "pollTimes": {
          "item": [
            {
              "mode": "everyHour"
            }
          ]
        },
        "sheetName": {
          "__rl": true,
          "mode": "list",
          "value": "gid=0",
          "cachedResultUrl": "https://docs.google.com/spreadsheets/d/1DKXYqpb0EWNYsbq2x8h5xqUWXy772toNDVrl8d-8nfA/edit#gid=0",
          "cachedResultName": "Restaurant"
        },
        "documentId": {
          "__rl": true,
          "mode": "list",
          "value": "1DKXYqpb0EWNYsbq2x8h5xqUWXy772toNDVrl8d-8nfA",
          "cachedResultUrl": "https://docs.google.com/spreadsheets/d/1DKXYqpb0EWNYsbq2x8h5xqUWXy772toNDVrl8d-8nfA/edit?usp=drivesdk",
          "cachedResultName": "Database ReCharge"
        }
      },
      "credentials": {
        "googleSheetsTriggerOAuth2Api": {
          "id": "F3lxq4bAfCrWKqMD",
          "name": "Oauth "
        }
      },
      "typeVersion": 1
    },
    {
      "id": "5a8f4c25-e22f-40f0-b139-50088dfeb8e4",
      "name": "Transform for Vector",
      "type": "n8n-nodes-base.code",
      "position": [
        3660,
        1060
      ],
      "parameters": {
        "jsCode": "// Transform data yang baru ditambah dari spreadsheet\nconst newData = $input.all().map(item => {\n  const data = item.json;\n  \n  // Skip jika data kosong\n  if (!data.Title || data.Title.trim() === '') {\n    return null;\n  }\n  \n  // Buat business summary untuk embedding\n  const businessSummary = `\n${data.Title} adalah ${data.Category || 'restoran'} yang berlokasi di ${data.Neighborhood || 'lokasi tidak diketahui'}. \nRating: ${data.Rating || 'belum ada rating'}/5 dengan ${data.Reviews || 0} review. \nHarga: ${data.Price || 'Tidak diketahui'}.\n${data.Description || ''}\n\nKeunggulan: ${data['Keunggulan Clean'] || 'Tidak ada info keunggulan'}\nFasilitas: ${data['Fasilitas Clean'] || 'Tidak ada info fasilitas'}  \nMetode Pembayaran: ${data['Pembayaran Clean'] || 'Tidak ada info pembayaran'}\nJam Operasional: ${data['Jam Operasional'] || 'Tidak tersedia'}\n\nKontak: ${data.Phone || 'Tidak ada nomor telepon'}\nWebsite: ${data.Website !== 'not found' ? data.Website : 'Tidak ada website'}\nAlamat: ${data.Address || 'Alamat tidak lengkap'}\n`.trim();\n\n  return {\n    // Content untuk embedding\n    business_summary: businessSummary,\n    \n    // Metadata\n    metadata: {\n      restaurant_name: data.Title,\n      category: data.Category,\n      location: data.Neighborhood,\n      phone: data.Phone,\n      rating: data.Rating,\n      total_reviews: data.Reviews,\n      lead_score: data['Lead Score'] || 0,\n      lead_quality: data['Lead Quality'] || 'Unknown',\n      keunggulan: data['Keunggulan Clean'] || '',\n      fasilitas: data['Fasilitas Clean'] || '',\n      pembayaran: data['Pembayaran Clean'] || '',\n      website: data.Website !== 'not found' ? data.Website : '',\n      price_range: data.Price || 'Tidak diketahui',\n      full_address: data.Address,\n      jam_operasional: data['Jam Operasional'] || 'Tidak tersedia',\n      row_number: data.row_number,\n      last_updated: new Date().toISOString(),\n      data_type: \"restaurant_lead\",\n      source: \"google_sheets_auto\"\n    }\n  };\n}).filter(item => item !== null);\n\nreturn newData;"
      },
      "typeVersion": 2
    },
    {
      "id": "d0223130-8df1-4f3b-9800-3ead95a29c5f",
      "name": "Check Existing Data",
      "type": "n8n-nodes-base.code",
      "position": [
        3880,
        1060
      ],
      "parameters": {
        "jsCode": "// Check dan handle existing data di Supabase vector database\nconst inputData = $input.all();\nconst processedData = [];\n\nfor (const item of inputData) {\n  const data = item.json;\n  \n  // Skip jika data kosong atau tidak valid\n  if (!data.Title || data.Title.trim() === '') {\n    console.log(`Skipping empty data for row ${data.row_number}`);\n    continue;\n  }\n  \n  // Buat unique identifier berdasarkan kombinasi nama + alamat\n  const uniqueId = `${data.Title}_${data.Address}`.replace(/[^a-zA-Z0-9]/g, '_').toLowerCase();\n  \n  // Buat business summary untuk embedding\n  const businessSummary = `\nNama Restoran: ${data.Title}\nKategori: ${data.Category || 'Restoran'}\nLokasi: ${data.Neighborhood || 'Tidak diketahui'}\nAlamat: ${data.Address || 'Alamat tidak lengkap'}\nRating: ${data.Rating || 'Belum ada rating'}/5 (${data.Reviews || 0} reviews)\nHarga: ${data.Price || 'Tidak diketahui'}\nDeskripsi: ${data.Description || 'Tidak ada deskripsi'}\n\nDetail Bisnis:\n- Keunggulan: ${data.Keunggulan || 'Tidak ada info keunggulan'}\n- Fasilitas: ${data.Fasilitas || 'Tidak ada info fasilitas'}\n- Metode Pembayaran: ${data.Pembayaran || 'Tidak ada info pembayaran'}\n- Jam Operasional: ${data['Opening Hours'] || 'Tidak tersedia'}\n\nKontak:\n- Telepon: ${data.Phone || 'Tidak ada nomor telepon'}\n- Website: ${data.Website && data.Website !== 'not found' ? data.Website : 'Tidak ada website'}\n\nLead Score: ${data['Lead Score'] || 0}\nLead Quality: ${data['Lead Quality'] || 'Unknown'}\n`.trim();\n\n  // Prepare data untuk vector store\n  const vectorData = {\n    // Text content untuk embedding\n    pageContent: businessSummary,\n    \n    // Metadata untuk filtering dan searching\n    metadata: {\n      unique_id: uniqueId,\n      restaurant_name: data.Title,\n      category: data.Category || 'Restoran',\n      location: data.Neighborhood || 'Tidak diketahui',\n      full_address: data.Address || '',\n      phone: data.Phone || '',\n      website: data.Website && data.Website !== 'not found' ? data.Website : '',\n      rating: parseFloat(data.Rating) || 0,\n      total_reviews: parseInt(data.Reviews) || 0,\n      price_range: data.Price || 'Tidak diketahui',\n      lead_score: parseInt(data['Lead Score']) || 0,\n      lead_quality: data['Lead Quality'] || 'Unknown',\n      \n      // Additional business info\n      keunggulan: data.Keunggulan || '',\n      fasilitas: data.Fasilitas || '',\n      pembayaran: data.Pembayaran || '',\n      jam_operasional: data['Opening Hours'] || '',\n      \n      // System metadata\n      row_number: data.row_number,\n      data_source: 'google_sheets',\n      data_type: 'restaurant_lead',\n      last_updated: new Date().toISOString(),\n      \n      // Status tracking\n      contact_status: 'not_contacted',\n      is_active: true\n    },\n    \n    // Original row data untuk reference\n    original_data: data\n  };\n  \n  // Add flag untuk indicate ini adalah update atau insert baru\n  vectorData.metadata.is_update = !!data.row_number;\n  \n  processedData.push(vectorData);\n  \n  console.log(`Processed: ${data.Title} (ID: ${uniqueId})`);\n}\n\nconsole.log(`Total processed: ${processedData.length} items`);\n\nreturn processedData;"
      },
      "typeVersion": 2
    },
    {
      "id": "5793e2f7-4cd9-47d4-a54c-ca426a606204",
      "name": "RAG",
      "type": "@n8n/n8n-nodes-langchain.vectorStoreSupabase",
      "position": [
        2600,
        920
      ],
      "parameters": {
        "mode": "retrieve-as-tool",
        "topK": 20,
        "options": {},
        "toolName": "CompanyDocuments",
        "tableName": {
          "__rl": true,
          "mode": "list",
          "value": "documents",
          "cachedResultName": "documents"
        },
        "toolDescription": "Search CompanyDocument knowledge base and business documents"
      },
      "credentials": {
        "supabaseApi": {
          "id": "rb73xq0erYUAZCau",
          "name": "REcharge"
        }
      },
      "typeVersion": 1.1
    },
    {
      "id": "4d621157-f7c5-40f3-b074-9b291834d502",
      "name": "Leads",
      "type": "@n8n/n8n-nodes-langchain.vectorStoreSupabase",
      "position": [
        2880,
        920
      ],
      "parameters": {
        "mode": "retrieve-as-tool",
        "topK": 20,
        "options": {},
        "toolName": "RestaurantLeads",
        "tableName": {
          "__rl": true,
          "mode": "list",
          "value": "restaurant_leads",
          "cachedResultName": "restaurant_leads"
        },
        "toolDescription": "=Search restaurant leads and potential clients data"
      },
      "credentials": {
        "supabaseApi": {
          "id": "rb73xq0erYUAZCau",
          "name": "REcharge"
        }
      },
      "typeVersion": 1.1
    },
    {
      "id": "a0d34cae-29ed-4bcc-960f-1c32187ed7ac",
      "name": "Embeddings OpenAI2",
      "type": "@n8n/n8n-nodes-langchain.embeddingsOpenAi",
      "position": [
        2880,
        1060
      ],
      "parameters": {
        "options": {}
      },
      "credentials": {
        "openAiApi": {
          "id": "IWdqsaVAq1AL1S28",
          "name": "n8n - Money manager Khairul"
        }
      },
      "typeVersion": 1.2
    },
    {
      "id": "92a0a539-b14a-4b12-9bdf-3f6d1b4baf5f",
      "name": "Sticky Note2",
      "type": "n8n-nodes-base.stickyNote",
      "position": [
        3420,
        940
      ],
      "parameters": {
        "color": 5,
        "width": 1100,
        "height": 600,
        "content": "# Potential Leads Knowledge Base\n"
      },
      "typeVersion": 1
    },
    {
      "id": "ebf1d8e0-f7a2-4303-97be-07f70f4430c2",
      "name": "Sticky Note3",
      "type": "n8n-nodes-base.stickyNote",
      "position": [
        2020,
        640
      ],
      "parameters": {
        "width": 1360,
        "height": 560,
        "content": "# Respond as a chatbot"
      },
      "typeVersion": 1
    },
    {
      "id": "23ea6d0b-c66a-4d74-8b42-b09065abeace",
      "name": "WAHA Trigger",
      "type": "@devlikeapro/n8n-nodes-waha.wahaTrigger",
      "disabled": true,
      "position": [
        1700,
        340
      ],
      "webhookId": "886de7ed-318f-4c8f-8d98-01720ddc8b82",
      "parameters": {},
      "typeVersion": 202502
    },
    {
      "id": "07c892fe-1c58-4c1e-943c-700c6bc1926d",
      "name": "AI Agent1",
      "type": "@n8n/n8n-nodes-langchain.agent",
      "position": [
        2380,
        1340
      ],
      "parameters": {
        "options": {
          "systemMessage": "=# Company Business Intelligence Assistant\n\nYou are \"MinCharge\", a specialized business intelligence assistant for the company. Your primary responsibility is to provide answers exclusively based on the available knowledge sources.\n\n## Knowledge Sources\nYou have access to two critical knowledge bases:\n1. **CompanyDocuments** - Contains business documents, service guides, company information, and operational procedures\n2. **RestaurantLeads** - Contains potential restaurant client data including ratings, contact information, business details, and market insights\n\n## 🚨 CRITICAL: Tool Selection Protocol\n\n### MANDATORY Tool Usage Rules:\n**CompanyDocuments tool MUST be used for:**\n- ANY question about company services, capabilities, or offerings\n- Pricing inquiries (\"how much\", \"cost\", \"price\", \"fee\")\n- Company information (\"about the company\", \"what is the company\", \"company details\")\n- Business processes (\"how does the company work\", \"process\", \"procedure\")\n- Service features and benefits\n- Any question containing keywords: company, service, price, cost, business, how to, process, capability, offering\n\n**RestaurantLeads tool MUST be used for:**\n- Lead generation and prospecting requests\n- Restaurant recommendations and listings\n- Market analysis and competitive intelligence\n- Location-based restaurant queries\n- Rating, review, and business characteristic analysis\n- Contact information and outreach data\n\n### Search Strategy Hierarchy:\n1. **Company-specific queries** → Use CompanyDocuments FIRST, always\n2. **Restaurant/lead queries** → Use RestaurantLeads FIRST\n3. **Business intelligence/strategy** → Use BOTH tools sequentially\n4. **Ambiguous queries** → Default to CompanyDocuments first, then RestaurantLeads if needed\n\n## Execution Process (Follow Strictly):\n1. **Query Classification**: \n   - Identify if query mentions company, services, pricing, or company info\n   - If YES → Immediately use CompanyDocuments tool\n   - If restaurant/lead focused → Use RestaurantLeads tool\n   - If business strategy → Use both tools\n\n2. **Tool Selection Verification**:\n   - Double-check that you're using the correct tool for the query type\n   - When in doubt about company-related content → ALWAYS search CompanyDocuments\n\n3. **Search Execution**: \n   - Execute search in identified tool(s) before generating any response\n   - Use specific, relevant keywords from user query\n\n4. **Response Generation**: \n   - Base response entirely on search results\n   - Clearly cite which knowledge base provided the information\n   - Match user's language (Indonesian/English)\n\n## Core Operating Principles\n- **MANDATORY SEARCH**: Never respond without searching appropriate knowledge base first\n- **NO EXTERNAL KNOWLEDGE**: Absolutely no information from outside the knowledge bases\n- **EXPLICIT SOURCE CITATION**: Always state \"Based on CompanyDocuments...\" or \"According to RestaurantLeads...\"\n- **LANGUAGE MATCHING**: Respond in exact same language as user input\n- **ACCURACY OVER COMPLETENESS**: Better to say \"no information found\" than guess\n\n## Quality Assurance Checklist\nBefore every response, verify:\n- ✅ Did I search the appropriate knowledge base?\n- ✅ Is my answer based solely on search results?\n- ✅ Did I cite the correct source?\n- ✅ Am I responding in the user's language?\n- ✅ Did I avoid using external knowledge?\n\n## Error Handling\nIf no relevant information found in knowledge bases:\n- **English**: \"I searched [specific knowledge base] but don't have information about [topic]. Could you provide more specific details or rephrase your question?\"\n- **Indonesian**: \"Saya telah mencari di [basis pengetahuan spesifik] tetapi tidak memiliki informasi tentang [topik]. Bisakah Anda memberikan detail yang lebih spesifik atau mengubah pertanyaan Anda?\"\n\n## Debugging Mode\nAlways mention in your response which tool you used:\n- \"After searching CompanyDocuments...\"\n- \"Based on my search in RestaurantLeads...\"\n- \"From both knowledge bases...\"\n\nThis helps identify if tool selection is working correctly.\n\nRemember: Your value comes from providing accurate, source-backed intelligence from the company's specific business context and restaurant lead database. Always search first, cite sources, and match the user's language."
        }
      },
      "typeVersion": 2
    },
    {
      "id": "80997c1f-4ddd-47b0-be81-bc75abd6dbfd",
      "name": "Embeddings OpenAI3",
      "type": "@n8n/n8n-nodes-langchain.embeddingsOpenAi",
      "position": [
        2580,
        1660
      ],
      "parameters": {
        "options": {}
      },
      "credentials": {
        "openAiApi": {
          "id": "IWdqsaVAq1AL1S28",
          "name": "n8n - Money manager Khairul"
        }
      },
      "typeVersion": 1.2
    },
    {
      "id": "1640e426-2920-4e77-bac4-779cb6081194",
      "name": "RAG1",
      "type": "@n8n/n8n-nodes-langchain.vectorStoreSupabase",
      "position": [
        2600,
        1520
      ],
      "parameters": {
        "mode": "retrieve-as-tool",
        "topK": 20,
        "options": {},
        "toolName": "CompanyDocuments",
        "tableName": {
          "__rl": true,
          "mode": "list",
          "value": "documents",
          "cachedResultName": "documents"
        },
        "useReranker": true,
        "toolDescription": "=MANDATORY TOOL for questions about: CompanyDocument services, pricing, company information, business processes, operational procedures, service capabilities, company policies, internal guidelines, and any ReCharge-specific business inquiries. Always use this tool first when users ask about ReCharge services or company information."
      },
      "credentials": {
        "supabaseApi": {
          "id": "rb73xq0erYUAZCau",
          "name": "REcharge"
        }
      },
      "typeVersion": 1.1
    },
    {
      "id": "6c8f2db0-ec5b-4164-9f4a-ea36d33478e6",
      "name": "Leads1",
      "type": "@n8n/n8n-nodes-langchain.vectorStoreSupabase",
      "position": [
        2880,
        1520
      ],
      "parameters": {
        "mode": "retrieve-as-tool",
        "topK": 20,
        "options": {},
        "toolName": "RestaurantLeads",
        "tableName": {
          "__rl": true,
          "mode": "list",
          "value": "restaurant_leads",
          "cachedResultName": "restaurant_leads"
        },
        "useReranker": true,
        "toolDescription": "=Search restaurant leads database containing potential client information, ratings, contact details, business characteristics, location data, and market insights. Use for lead generation, market analysis, and client prospecting."
      },
      "credentials": {
        "supabaseApi": {
          "id": "rb73xq0erYUAZCau",
          "name": "REcharge"
        }
      },
      "typeVersion": 1.1
    },
    {
      "id": "21d6d2c8-1ad3-455e-8171-77ed6f60f5e1",
      "name": "Embeddings OpenAI4",
      "type": "@n8n/n8n-nodes-langchain.embeddingsOpenAi",
      "position": [
        2900,
        1660
      ],
      "parameters": {
        "options": {}
      },
      "credentials": {
        "openAiApi": {
          "id": "IWdqsaVAq1AL1S28",
          "name": "n8n - Money manager Khairul"
        }
      },
      "typeVersion": 1.2
    },
    {
      "id": "2b711442-2dd0-43b7-b3a0-19a785bc0417",
      "name": "Sticky Note4",
      "type": "n8n-nodes-base.stickyNote",
      "position": [
        2020,
        1240
      ],
      "parameters": {
        "color": 4,
        "width": 1360,
        "height": 580,
        "content": "# Send Message"
      },
      "typeVersion": 1
    },
    {
      "id": "782a8690-70f8-403f-8d59-13bf96b343d7",
      "name": "When chat message received",
      "type": "@n8n/n8n-nodes-langchain.chatTrigger",
      "position": [
        2200,
        1340
      ],
      "webhookId": "2d2ee28f-a0f6-4e3f-ace2-91558f2fae95",
      "parameters": {
        "options": {}
      },
      "typeVersion": 1.1
    },
    {
      "id": "c4a980f5-681a-4d5b-bcf7-504d5b832a53",
      "name": "Chat Memory",
      "type": "@n8n/n8n-nodes-langchain.memoryPostgresChat",
      "position": [
        2460,
        1500
      ],
      "parameters": {
        "contextWindowLength": 20
      },
      "credentials": {
        "postgres": {
          "id": "8PMGgjtS4muxnKxT",
          "name": "ReCharge Database"
        }
      },
      "typeVersion": 1.3
    },
    {
      "id": "6faff427-ccc8-4747-801f-e4846460c7c5",
      "name": "Chat Model",
      "type": "@n8n/n8n-nodes-langchain.lmChatOpenAi",
      "position": [
        2320,
        1500
      ],
      "parameters": {
        "model": {
          "__rl": true,
          "mode": "list",
          "value": "gpt-4o-mini"
        },
        "options": {}
      },
      "credentials": {
        "openAiApi": {
          "id": "IWdqsaVAq1AL1S28",
          "name": "n8n - Money manager Khairul"
        }
      },
      "typeVersion": 1.2
    },
    {
      "id": "579ac8c8-359b-4297-b93b-4dff7dd41928",
      "name": "Reranker Cohere",
      "type": "@n8n/n8n-nodes-langchain.rerankerCohere",
      "position": [
        2720,
        1660
      ],
      "parameters": {
        "modelName": "rerank-multilingual-v3.0"
      },
      "credentials": {
        "cohereApi": {
          "id": "vEf2FhO0BZLEAmaR",
          "name": "trial Cohere"
        }
      },
      "typeVersion": 1
    },
    {
      "id": "bf15a02a-a529-4c06-8bc4-7e595cde718b",
      "name": "Reranker Cohere1",
      "type": "@n8n/n8n-nodes-langchain.rerankerCohere",
      "position": [
        3020,
        1660
      ],
      "parameters": {
        "modelName": "rerank-multilingual-v3.0"
      },
      "credentials": {
        "cohereApi": {
          "id": "vEf2FhO0BZLEAmaR",
          "name": "trial Cohere"
        }
      },
      "typeVersion": 1
    },
    {
      "id": "547e4f7d-737c-4819-85af-fa02e3196da9",
      "name": "Set Location",
      "type": "n8n-nodes-base.set",
      "position": [
        2300,
        180
      ],
      "parameters": {
        "options": {},
        "assignments": {
          "assignments": [
            {
              "id": "e80e3961-4f18-4e38-8642-4c35075f13a1",
              "name": "lokasi",
              "type": "string",
              "value": "Bali"
            }
          ]
        }
      },
      "typeVersion": 3.4
    }
  ],
  "active": false,
  "pinData": {},
  "settings": {
    "executionOrder": "v1"
  },
  "versionId": "f96e50a9-3b2c-4de0-a80d-c5bf5cb2b336",
  "connections": {
    "RAG": {
      "ai_tool": [
        [
          {
            "node": "AI Agent",
            "type": "ai_tool",
            "index": 0
          }
        ]
      ]
    },
    "RAG1": {
      "ai_tool": [
        [
          {
            "node": "AI Agent1",
            "type": "ai_tool",
            "index": 0
          }
        ]
      ]
    },
    "Leads": {
      "ai_tool": [
        [
          {
            "node": "AI Agent",
            "type": "ai_tool",
            "index": 0
          }
        ]
      ]
    },
    "Leads1": {
      "ai_tool": [
        [
          {
            "node": "AI Agent1",
            "type": "ai_tool",
            "index": 0
          }
        ]
      ]
    },
    "small3": {
      "ai_embedding": [
        [
          {
            "node": "Supabase Vector Store2",
            "type": "ai_embedding",
            "index": 0
          }
        ]
      ]
    },
    "Webhook": {
      "main": [
        [
          {
            "node": "Get Leads",
            "type": "main",
            "index": 0
          }
        ]
      ]
    },
    "AI Agent": {
      "main": [
        []
      ]
    },
    "Get Data": {
      "main": [
        [
          {
            "node": "Loop Over Items",
            "type": "main",
            "index": 0
          }
        ]
      ]
    },
    "AI Agent1": {
      "main": [
        []
      ]
    },
    "Get Leads": {
      "main": [
        [
          {
            "node": "Clean Data",
            "type": "main",
            "index": 0
          }
        ]
      ]
    },
    "Chat Model": {
      "ai_languageModel": [
        [
          {
            "node": "AI Agent1",
            "type": "ai_languageModel",
            "index": 0
          }
        ]
      ]
    },
    "Clean Data": {
      "main": [
        [
          {
            "node": "Update Data",
            "type": "main",
            "index": 0
          }
        ]
      ]
    },
    "Get Result": {
      "main": [
        [
          {
            "node": "Append Leads",
            "type": "main",
            "index": 0
          }
        ]
      ]
    },
    "Chat Memory": {
      "ai_memory": [
        [
          {
            "node": "AI Agent1",
            "type": "ai_memory",
            "index": 0
          }
        ]
      ]
    },
    "Scrape Maps": {
      "main": [
        [
          {
            "node": "Get Result",
            "type": "main",
            "index": 0
          }
        ]
      ]
    },
    "Search File": {
      "main": [
        [
          {
            "node": "Get Data",
            "type": "main",
            "index": 0
          }
        ]
      ]
    },
    "Append Leads": {
      "main": [
        [
          {
            "node": "HTTP Request1",
            "type": "main",
            "index": 0
          }
        ]
      ]
    },
    "Set Location": {
      "main": [
        [
          {
            "node": "Scrape Maps",
            "type": "main",
            "index": 0
          }
        ]
      ]
    },
    "WAHA Trigger": {
      "main": [
        [],
        [
          {
            "node": "AI Agent",
            "type": "main",
            "index": 0
          }
        ]
      ]
    },
    "Loop Over Items": {
      "main": [
        [],
        [
          {
            "node": "Supabase Vector Store",
            "type": "main",
            "index": 0
          }
        ]
      ]
    },
    "Reranker Cohere": {
      "ai_reranker": [
        [
          {
            "node": "RAG1",
            "type": "ai_reranker",
            "index": 0
          }
        ]
      ]
    },
    "Reranker Cohere1": {
      "ai_reranker": [
        [
          {
            "node": "Leads1",
            "type": "ai_reranker",
            "index": 0
          }
        ]
      ]
    },
    "Embeddings OpenAI": {
      "ai_embedding": [
        [
          {
            "node": "Supabase Vector Store",
            "type": "ai_embedding",
            "index": 0
          }
        ]
      ]
    },
    "OpenAI Chat Model": {
      "ai_languageModel": [
        [
          {
            "node": "AI Agent",
            "type": "ai_languageModel",
            "index": 0
          }
        ]
      ]
    },
    "Embeddings OpenAI1": {
      "ai_embedding": [
        [
          {
            "node": "RAG",
            "type": "ai_embedding",
            "index": 0
          }
        ]
      ]
    },
    "Embeddings OpenAI2": {
      "ai_embedding": [
        [
          {
            "node": "Leads",
            "type": "ai_embedding",
            "index": 0
          }
        ]
      ]
    },
    "Embeddings OpenAI3": {
      "ai_embedding": [
        [
          {
            "node": "RAG1",
            "type": "ai_embedding",
            "index": 0
          }
        ]
      ]
    },
    "Embeddings OpenAI4": {
      "ai_embedding": [
        [
          {
            "node": "Leads1",
            "type": "ai_embedding",
            "index": 0
          }
        ]
      ]
    },
    "Check Existing Data": {
      "main": [
        [
          {
            "node": "Supabase Vector Store2",
            "type": "main",
            "index": 0
          }
        ]
      ]
    },
    "Default Data Loader": {
      "ai_document": [
        [
          {
            "node": "Supabase Vector Store",
            "type": "ai_document",
            "index": 0
          }
        ]
      ]
    },
    "Default Data Loader2": {
      "ai_document": [
        [
          {
            "node": "Supabase Vector Store2",
            "type": "ai_document",
            "index": 0
          }
        ]
      ]
    },
    "Google Drive Trigger": {
      "main": [
        [
          {
            "node": "Search File",
            "type": "main",
            "index": 0
          }
        ]
      ]
    },
    "Postgres Chat Memory": {
      "ai_memory": [
        [
          {
            "node": "AI Agent",
            "type": "ai_memory",
            "index": 0
          }
        ]
      ]
    },
    "Transform for Vector": {
      "main": [
        [
          {
            "node": "Check Existing Data",
            "type": "main",
            "index": 0
          }
        ]
      ]
    },
    "Google Sheets Trigger": {
      "main": [
        [
          {
            "node": "Transform for Vector",
            "type": "main",
            "index": 0
          }
        ]
      ]
    },
    "Supabase Vector Store": {
      "main": [
        [
          {
            "node": "Loop Over Items",
            "type": "main",
            "index": 0
          }
        ]
      ]
    },
    "When chat message received": {
      "main": [
        [
          {
            "node": "AI Agent1",
            "type": "main",
            "index": 0
          }
        ]
      ]
    },
    "Recursive Character Text Splitter": {
      "ai_textSplitter": [
        [
          {
            "node": "Default Data Loader",
            "type": "ai_textSplitter",
            "index": 0
          }
        ]
      ]
    },
    "Recursive Character Text Splitter1": {
      "ai_textSplitter": [
        [
          {
            "node": "Default Data Loader2",
            "type": "ai_textSplitter",
            "index": 0
          }
        ]
      ]
    },
    "When clicking ‘Execute workflow’": {
      "main": [
        [
          {
            "node": "Set Location",
            "type": "main",
            "index": 0
          }
        ]
      ]
    }
  }
}
```
</details>