# Node Compatibility Matrix

This matrix shows connection compatibility between nodes. Rows are source nodes, columns are target nodes.

| Source Node ↓ / Target Node → | Code | Function | HTTP Request | If | Set | Webhook | Merge | Airtable | Discord | Dropbox | GitHub | Google Drive | Gmail | Google She.. | MySQL | Notion | OpenAI | Postgres | S3 | Slack | Telegram | Action Net.. | ActiveCamp.. | ActiveCamp.. | Acuity Sch.. | Adalo | Affinity | Affinity T.. | Agile CRM | Airtable T.. | Airtop | AI Transform | AMQP Sender | AMQP Trigger | APITemplat.. | Asana | Asana Trig.. | Automizy | Autopilot | Autopilot .. | AWS Lambda | AWS SNS | AWS SNS Tr.. | AWS Certif.. | AWS Cognito | AWS Compre.. | AWS DynamoDB | AWS ELB | AWS IAM | AWS Rekogn.. |
| --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- |
| Code | - | + | + | + | + | X | + | + | + | + | + | + | + | + | + | + | + | + | + | + | + | + | + | X | X | + | + | X | + | X | + | + | + | X | + | + | X | + | + | X | + | + | X | + | + | + | + | + | + | + |
| Function | + | - | + | + | + | X | + | + | + | + | + | + | + | + | + | + | + | + | + | + | + | + | + | X | X | + | + | X | + | X | + | + | + | X | + | + | X | + | + | X | + | + | X | + | + | + | + | + | + | + |
| HTTP Request | + | + | - | + | + | X | + | + | + | + | + | + | + | + | + | + | + | + | + | + | + | + | + | X | X | + | + | X | + | X | + | + | + | X | + | + | X | + | + | X | + | + | X | + | + | + | + | + | + | + |
| If | + | + | + | - | + | X | + | + | + | + | + | + | + | + | + | + | + | + | + | + | + | + | + | X | X | + | + | X | + | X | + | + | + | X | + | + | X | + | + | X | + | + | X | + | + | + | + | + | + | + |
| Set | + | + | + | + | - | X | + | + | + | + | + | + | + | + | + | + | + | + | + | + | + | + | + | X | X | + | + | X | + | X | + | + | + | X | + | + | X | + | + | X | + | + | X | + | + | + | + | + | + | + |
| Webhook | ++ | ++ | ++ | ++ | ++ | - | ++ | ++ | ++ | ++ | ++ | ++ | ++ | ++ | ++ | ++ | ++ | ++ | ++ | ++ | ++ | ++ | ++ | X | X | ++ | ++ | X | ++ | X | ++ | ++ | ++ | X | ++ | ++ | X | ++ | ++ | X | ++ | ++ | X | ++ | ++ | ++ | ++ | ++ | ++ | ++ |
| Merge | + | + | + | + | + | X | - | + | + | + | + | + | + | + | + | + | + | + | + | + | + | + | + | X | X | + | + | X | + | X | + | + | + | X | + | + | X | + | + | X | + | + | X | + | + | + | + | + | + | + |
| Airtable | + | + | + | + | + | X | + | - | + | + | + | + | + | + | + | + | + | + | + | + | + | + | + | X | X | + | + | X | + | X | + | + | + | X | + | + | X | + | + | X | + | + | X | + | + | + | + | + | + | + |
| Discord | + | + | + | + | + | X | + | + | - | + | + | + | + | + | + | + | + | + | + | + | + | + | + | X | X | + | + | X | + | X | + | + | + | X | + | + | X | + | + | X | + | + | X | + | + | + | + | + | + | + |
| Dropbox | + | + | + | + | + | X | + | + | + | - | + | + | + | + | + | + | + | + | + | + | + | + | + | X | X | + | + | X | + | X | + | + | + | X | + | + | X | + | + | X | + | + | X | + | + | + | + | + | + | + |
| GitHub | + | + | + | + | + | X | + | + | + | + | - | + | + | + | + | + | + | + | + | + | + | + | + | X | X | + | + | X | + | X | + | + | + | X | + | + | X | + | + | X | + | + | X | + | + | + | + | + | + | + |
| Google Drive | + | + | + | + | + | X | + | + | + | + | + | - | + | + | + | + | + | + | + | + | + | + | + | X | X | + | + | X | + | X | + | + | + | X | + | + | X | + | + | X | + | + | X | + | + | + | + | + | + | + |
| Gmail | + | + | + | + | + | X | + | + | + | + | + | + | - | + | + | + | + | + | + | + | + | + | + | X | X | + | + | X | + | X | + | + | + | X | + | + | X | + | + | X | + | + | X | + | + | + | + | + | + | + |
| Google Sheets | + | + | + | + | + | X | + | + | + | + | + | + | + | - | + | + | + | + | + | + | + | + | + | X | X | + | + | X | + | X | + | + | + | X | + | + | X | + | + | X | + | + | X | + | + | + | + | + | + | + |
| MySQL | + | + | + | + | + | X | + | + | + | + | + | + | + | + | - | + | + | + | + | + | + | + | + | X | X | + | + | X | + | X | + | + | + | X | + | + | X | + | + | X | + | + | X | + | + | + | + | + | + | + |
| Notion | + | + | + | + | + | X | + | + | + | + | + | + | + | + | + | - | + | + | + | + | + | + | + | X | X | + | + | X | + | X | + | + | + | X | + | + | X | + | + | X | + | + | X | + | + | + | + | + | + | + |
| OpenAI | + | + | + | + | + | X | + | + | + | + | + | + | + | + | + | + | - | + | + | + | + | + | + | X | X | + | + | X | + | X | + | + | + | X | + | + | X | + | + | X | + | + | X | + | + | + | + | + | + | + |
| Postgres | + | + | + | + | + | X | + | + | + | + | + | + | + | + | + | + | + | - | + | + | + | + | + | X | X | + | + | X | + | X | + | + | + | X | + | + | X | + | + | X | + | + | X | + | + | + | + | + | + | + |
| S3 | + | + | + | + | + | X | + | + | + | + | + | + | + | + | + | + | + | + | - | + | + | + | + | X | X | + | + | X | + | X | + | + | + | X | + | + | X | + | + | X | + | + | X | + | + | + | + | + | + | + |
| Slack | + | + | + | + | + | X | + | + | + | + | + | + | + | + | + | + | + | + | + | - | + | + | + | X | X | + | + | X | + | X | + | + | + | X | + | + | X | + | + | X | + | + | X | + | + | + | + | + | + | + |
| Telegram | + | + | + | + | + | X | + | + | + | + | + | + | + | + | + | + | + | + | + | + | - | + | + | X | X | + | + | X | + | X | + | + | + | X | + | + | X | + | + | X | + | + | X | + | + | + | + | + | + | + |
| Action Network | + | + | + | + | + | X | + | + | + | + | + | + | + | + | + | + | + | + | + | + | + | - | + | X | X | + | + | X | + | X | + | + | + | X | + | + | X | + | + | X | + | + | X | + | + | + | + | + | + | + |
| ActiveCampaign | + | + | + | + | + | X | + | + | + | + | + | + | + | + | + | + | + | + | + | + | + | + | - | X | X | + | + | X | + | X | + | + | + | X | + | + | X | + | + | X | + | + | X | + | + | + | + | + | + | + |
| ActiveCampaign Tri.. | ++ | ++ | ++ | ++ | ++ | X | ++ | ++ | ++ | ++ | ++ | ++ | ++ | ++ | ++ | ++ | ++ | ++ | ++ | ++ | ++ | ++ | ++ | - | X | ++ | ++ | X | ++ | X | ++ | ++ | ++ | X | ++ | ++ | X | ++ | ++ | X | ++ | ++ | X | ++ | ++ | ++ | ++ | ++ | ++ | ++ |
| Acuity Scheduling .. | ++ | ++ | ++ | ++ | ++ | X | ++ | ++ | ++ | ++ | ++ | ++ | ++ | ++ | ++ | ++ | ++ | ++ | ++ | ++ | ++ | ++ | ++ | X | - | ++ | ++ | X | ++ | X | ++ | ++ | ++ | X | ++ | ++ | X | ++ | ++ | X | ++ | ++ | X | ++ | ++ | ++ | ++ | ++ | ++ | ++ |
| Adalo | + | + | + | + | + | X | + | + | + | + | + | + | + | + | + | + | + | + | + | + | + | + | + | X | X | - | + | X | + | X | + | + | + | X | + | + | X | + | + | X | + | + | X | + | + | + | + | + | + | + |
| Affinity | + | + | + | + | + | X | + | + | + | + | + | + | + | + | + | + | + | + | + | + | + | + | + | X | X | + | - | X | + | X | + | + | + | X | + | + | X | + | + | X | + | + | X | + | + | + | + | + | + | + |
| Affinity Trigger | ++ | ++ | ++ | ++ | ++ | X | ++ | ++ | ++ | ++ | ++ | ++ | ++ | ++ | ++ | ++ | ++ | ++ | ++ | ++ | ++ | ++ | ++ | X | X | ++ | ++ | - | ++ | X | ++ | ++ | ++ | X | ++ | ++ | X | ++ | ++ | X | ++ | ++ | X | ++ | ++ | ++ | ++ | ++ | ++ | ++ |
| Agile CRM | + | + | + | + | + | X | + | + | + | + | + | + | + | + | + | + | + | + | + | + | + | + | + | X | X | + | + | X | - | X | + | + | + | X | + | + | X | + | + | X | + | + | X | + | + | + | + | + | + | + |
| Airtable Trigger | ++ | ++ | ++ | ++ | ++ | X | ++ | ++ | ++ | ++ | ++ | ++ | ++ | ++ | ++ | ++ | ++ | ++ | ++ | ++ | ++ | ++ | ++ | X | X | ++ | ++ | X | ++ | - | ++ | ++ | ++ | X | ++ | ++ | X | ++ | ++ | X | ++ | ++ | X | ++ | ++ | ++ | ++ | ++ | ++ | ++ |
| Airtop | + | + | + | + | + | X | + | + | + | + | + | + | + | + | + | + | + | + | + | + | + | + | + | X | X | + | + | X | + | X | - | + | + | X | + | + | X | + | + | X | + | + | X | + | + | + | + | + | + | + |
| AI Transform | + | + | + | + | + | X | + | + | + | + | + | + | + | + | + | + | + | + | + | + | + | + | + | X | X | + | + | X | + | X | + | - | + | X | + | + | X | + | + | X | + | + | X | + | + | + | + | + | + | + |
| AMQP Sender | + | + | + | + | + | X | + | + | + | + | + | + | + | + | + | + | + | + | + | + | + | + | + | X | X | + | + | X | + | X | + | + | - | X | + | + | X | + | + | X | + | + | X | + | + | + | + | + | + | + |
| AMQP Trigger | ++ | ++ | ++ | ++ | ++ | X | ++ | ++ | ++ | ++ | ++ | ++ | ++ | ++ | ++ | ++ | ++ | ++ | ++ | ++ | ++ | ++ | ++ | X | X | ++ | ++ | X | ++ | X | ++ | ++ | ++ | - | ++ | ++ | X | ++ | ++ | X | ++ | ++ | X | ++ | ++ | ++ | ++ | ++ | ++ | ++ |
| APITemplate.io | + | + | + | + | + | X | + | + | + | + | + | + | + | + | + | + | + | + | + | + | + | + | + | X | X | + | + | X | + | X | + | + | + | X | - | + | X | + | + | X | + | + | X | + | + | + | + | + | + | + |
| Asana | + | + | + | + | + | X | + | + | + | + | + | + | + | + | + | + | + | + | + | + | + | + | + | X | X | + | + | X | + | X | + | + | + | X | + | - | X | + | + | X | + | + | X | + | + | + | + | + | + | + |
| Asana Trigger | ++ | ++ | ++ | ++ | ++ | X | ++ | ++ | ++ | ++ | ++ | ++ | ++ | ++ | ++ | ++ | ++ | ++ | ++ | ++ | ++ | ++ | ++ | X | X | ++ | ++ | X | ++ | X | ++ | ++ | ++ | X | ++ | ++ | - | ++ | ++ | X | ++ | ++ | X | ++ | ++ | ++ | ++ | ++ | ++ | ++ |
| Automizy | + | + | + | + | + | X | + | + | + | + | + | + | + | + | + | + | + | + | + | + | + | + | + | X | X | + | + | X | + | X | + | + | + | X | + | + | X | - | + | X | + | + | X | + | + | + | + | + | + | + |
| Autopilot | + | + | + | + | + | X | + | + | + | + | + | + | + | + | + | + | + | + | + | + | + | + | + | X | X | + | + | X | + | X | + | + | + | X | + | + | X | + | - | X | + | + | X | + | + | + | + | + | + | + |
| Autopilot Trigger | ++ | ++ | ++ | ++ | ++ | X | ++ | ++ | ++ | ++ | ++ | ++ | ++ | ++ | ++ | ++ | ++ | ++ | ++ | ++ | ++ | ++ | ++ | X | X | ++ | ++ | X | ++ | X | ++ | ++ | ++ | X | ++ | ++ | X | ++ | ++ | - | ++ | ++ | X | ++ | ++ | ++ | ++ | ++ | ++ | ++ |
| AWS Lambda | + | + | + | + | + | X | + | + | + | + | + | + | + | + | + | + | + | + | + | + | + | + | + | X | X | + | + | X | + | X | + | + | + | X | + | + | X | + | + | X | - | + | X | + | + | + | + | + | + | + |
| AWS SNS | + | + | + | + | + | X | + | + | + | + | + | + | + | + | + | + | + | + | + | + | + | + | + | X | X | + | + | X | + | X | + | + | + | X | + | + | X | + | + | X | + | - | X | + | + | + | + | + | + | + |
| AWS SNS Trigger | ++ | ++ | ++ | ++ | ++ | X | ++ | ++ | ++ | ++ | ++ | ++ | ++ | ++ | ++ | ++ | ++ | ++ | ++ | ++ | ++ | ++ | ++ | X | X | ++ | ++ | X | ++ | X | ++ | ++ | ++ | X | ++ | ++ | X | ++ | ++ | X | ++ | ++ | - | ++ | ++ | ++ | ++ | ++ | ++ | ++ |
| AWS Certificate Ma.. | + | + | + | + | + | X | + | + | + | + | + | + | + | + | + | + | + | + | + | + | + | + | + | X | X | + | + | X | + | X | + | + | + | X | + | + | X | + | + | X | + | + | X | - | + | + | + | + | + | + |
| AWS Cognito | + | + | + | + | + | X | + | + | + | + | + | + | + | + | + | + | + | + | + | + | + | + | + | X | X | + | + | X | + | X | + | + | + | X | + | + | X | + | + | X | + | + | X | + | - | + | + | + | + | + |
| AWS Comprehend | + | + | + | + | + | X | + | + | + | + | + | + | + | + | + | + | + | + | + | + | + | + | + | X | X | + | + | X | + | X | + | + | + | X | + | + | X | + | + | X | + | + | X | + | + | - | + | + | + | + |
| AWS DynamoDB | + | + | + | + | + | X | + | + | + | + | + | + | + | + | + | + | + | + | + | + | + | + | + | X | X | + | + | X | + | X | + | + | + | X | + | + | X | + | + | X | + | + | X | + | + | + | - | + | + | + |
| AWS ELB | + | + | + | + | + | X | + | + | + | + | + | + | + | + | + | + | + | + | + | + | + | + | + | X | X | + | + | X | + | X | + | + | + | X | + | + | X | + | + | X | + | + | X | + | + | + | + | - | + | + |
| AWS IAM | + | + | + | + | + | X | + | + | + | + | + | + | + | + | + | + | + | + | + | + | + | + | + | X | X | + | + | X | + | X | + | + | + | X | + | + | X | + | + | X | + | + | X | + | + | + | + | + | - | + |
| AWS Rekognition | + | + | + | + | + | X | + | + | + | + | + | + | + | + | + | + | + | + | + | + | + | + | + | X | X | + | + | X | + | X | + | + | + | X | + | + | X | + | + | X | + | + | X | + | + | + | + | + | + | - |

## Legend

- `++` High Compatibility (score ≥ 70) - Strongly recommended
- `+` Medium Compatibility (score 50-69) - Can connect
- `~` Low Compatibility (score < 50) - May be able to connect
- `X` Incompatible - Cannot connect
- `-` N/A - Same node